package cn.com.duiba.prize.center.api.remoteservice.galaxy;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.galaxy.DeductCreditsRequest;
import cn.com.duiba.prize.center.api.dto.projectx.AwardRequest;
import cn.com.duiba.prize.center.api.dto.projectx.FailStockResult;
import cn.com.duiba.prize.center.api.dto.projectx.UpdateStockRequest;

import java.util.List;


/**
 * 定向适配活动平台[duiba-galaxy]，提供统一下游服务
 *
 * @author fangxiaorun
 * @date 2022/10/24
 */
@AdvancedFeignClient
public interface RemoteGalaxyService {
    /**
     * 项目扣积分
     *
     * @param request 扣积分请求
     * @throws BizException 异常
     */
    void deductCredits(DeductCreditsRequest request) throws BizException;

    /**
     * 项目发奖
     * @param request 发奖请求
     * @return prize record id
     * @throws BizException 异常
     */
    Long award(AwardRequest request) throws BizException;

    /**
     * 扣除或增加库存 不具备事务性，失败对库存会返回，需要调用方自行处理
     * @param projectId project-x id
     * @param stockRequestList 扣库存请求
     * @return 失败列表
     * @throws BizException
     */
    List<FailStockResult> batchDeductStock(String projectId, List<UpdateStockRequest> stockRequestList) throws BizException;

    void testSync(List<String> projectNos);

    void fix();

}
