package cn.com.duiba.prize.center.api.remoteservice.prize;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.prize.ActivityOptionsDto;
import cn.com.duiba.prize.center.api.dto.prize.PrizeDetailDto;

import java.util.List;

/**
 * ClassName:RemoteActivityOptionService<br/>
 *
 * @author gey
 * @version 1.0
 * @date 创建时间：2018/3/22  17:13
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteActivityOptionService {

	/**
	 *
	 * findActivityOptions:根据opId,duibaId,activityType 查询活动配置的奖品信息 <br/>
	 *
	 * @param opId
	 * @param duibaId
	 * @param activityType
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	List<ActivityOptionsDto> findActivityOptions(Long opId, Long duibaId, String activityType, Long appId) throws BizException;

	/**
	 * findActivityOptionsToKJJ
	 * 客集集定制 根据opId 查询活动配置的奖品信息 <br/>
	 *
	 * @param opId 入库ID
	 * @return
	 * @since JDK 1.6
	 */
	List<ActivityOptionsDto> findActivityOptionsToKjj(Long opId) throws BizException;

	/**
	 *
	 * getPrizeDetail:查询奖品信息 <br/>
	 *
	 * @param appItemId
	 * @param itemId
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	PrizeDetailDto getPrizeDetail(Long appItemId, Long itemId, Long appId) throws BizException;

	/**
	 * 根据奖品id查询奖品信息
	 * @param id
	 * @param actType
	 * @param isDuiba
	 * @return
	 */
	ActivityOptionsDto findById(Long id, String actType, boolean isDuiba);

	/**
	 * 新增或修改 开发者入库活动奖品 定制专用
	 */
	void saveOrUpdateCustomActivityOptions(List<ActivityOptionsDto> options, Long operatingActivityId);

	/**
	 * 查询 开发者入库活动奖品 定制专用
	 */
	List<ActivityOptionsDto> selectCustomActivityOptions(Long operatingActivityId);

	/**
	 * 查询某款活动某个用户的某个奖品的中奖次数
	 * @param consumerId 用户id
	 * @param opId 活动id
	 * @param activityType 活动类型
	 * @see cn.com.duiba.api.enums.prize.PrizeProcessTypeEnum
	 * @param optionId 奖品id
	 * @param limitScope 限制磊鑫
	 */
	Integer findConsumerWinOptionNumWithScope(Long consumerId, Long opId, Long optionId, String activityType, Integer limitScope) throws BizException;
}