package cn.com.duiba.prize.center.api.remoteservice.prize;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.prize.UserPrizeRecordDto;

import java.util.Date;

/**
 * 抽奖限制服务
 * @author lyj
 */
@AdvancedFeignClient
public interface RemoteLotteryLimitService {

    /**
     * 获取抽奖锁key
     *
     * @param appId      应用ID
     * @param consumerId 用户ID
     * @return 抽奖key
     */
    String getDrawLockKey(Long appId, Long consumerId);

    /**
     * 是否限制抽奖
     *
     * @param appId      应用ID
     * @param consumerId 用户ID
     * @param now        当前时间
     * @return 是否限制抽奖 true - 需要限制抽奖
     */
    boolean isLimitLottery(Long appId, Long consumerId, Date now);

    /**
     * 插入中奖记录
     *
     * @param userPrizeRecordDto 中奖记录参数
     */
    void insertLotteryRecord(UserPrizeRecordDto userPrizeRecordDto);

    /**
     * 是否是指定活动限制类型
     * @param activityType 活动类型
     * @param subType      子类型
     * @return true 是
     */
    boolean isOrderMultiActLimitType(Integer activityType, String subType);


}
