package cn.com.duiba.prize.center.api.remoteservice.prize;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.prize.UserPrizeRecordDto;
import cn.com.duiba.prize.center.api.dto.projectx.PrizeRecordDto;

import java.util.Date;
import java.util.List;

/**
 * 中奖记录查询
 * @author yyk
 */
@AdvancedFeignClient
public interface RemotePrizeRecordService {

    /**
     * 根据活动id，时间，领取状态查询中奖记录
     * @param projectId
     * @param startTime
     * @param endTime
     * @param drawStatus
     * @return
     */
    List<PrizeRecordDto> selectByProjectIdAndGmtAndStatus(String projectId, Date startTime, Date endTime, Integer drawStatus);

    /**
     * 更新到成功状态
     * 目前是给duiba-manager-web 定时任务定制使用，其他人勿动
     * @param prizeRecordDto
     * @return
     */
    int update2Success(PrizeRecordDto prizeRecordDto);

}
