/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.prize.center.api.enums;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public enum DuibaPrizeTypeEnum {
    OBJECT("object", "\u5b9e\u7269"),
    ALIPAY("alipay", "\u652f\u4ed8\u5b9d"),
    QB("qb", "QQ\u5e01"),
    PHONE_BILL("phonebill", "\u8bdd\u8d39"),
    COUPON("coupon", "\u4f18\u60e0\u52b5"),
    VIRTUAL_ITEM("virtual", "\u865a\u62df\u5546\u54c1"),
    COLLECT_GOODS("collectGoods", "\u96c6\u5361"),
    THANKS("thanks", "\u8c22\u8c22\u53c2\u4e0e"),
    TRY_AGAIN("again", "\u518d\u6765\u4e00\u6b21"),
    LUCK_BAG("lucky", "\u798f\u888b"),
    TUIA_LUCK_BAG("tuiaLucky", "\u63a8\u554a\u5e7f\u544a\u798f\u888b"),
    HAPPY_CODE("happyCode", "\u5f00\u5fc3\u7801"),
    ZYBANG_LUCK("zybangLuck", "\u4f5c\u4e1a\u5e2e\u798f\u888b"),
    CREDITS("credits", "\u79ef\u5206"),
    COLLECT_CARD("collectCard", "\u96c6\u5361\u5361\u7247");

    private String type;
    private String desc;
    private static final ImmutableSet<String> ACCESS_TO_BIZ_POOL;

    private DuibaPrizeTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static boolean isIncludeSpecialType(String type) {
        return DuibaPrizeTypeEnum.THANKS.type.equals(type) || DuibaPrizeTypeEnum.TRY_AGAIN.type.equals(type) || DuibaPrizeTypeEnum.LUCK_BAG.type.equals(type);
    }

    public static DuibaPrizeTypeEnum getByType(String type) {
        if (Objects.isNull(type)) {
            return null;
        }
        for (DuibaPrizeTypeEnum duibaPrizeTypeEnum : DuibaPrizeTypeEnum.values()) {
            if (!StringUtils.equals((String)type, (String)duibaPrizeTypeEnum.getType())) continue;
            return duibaPrizeTypeEnum;
        }
        return null;
    }

    public static boolean isAccessToBizPoolType(String type) {
        return ACCESS_TO_BIZ_POOL.contains((Object)type);
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ACCESS_TO_BIZ_POOL = ImmutableSet.of((Object)DuibaPrizeTypeEnum.COLLECT_GOODS.type, (Object)DuibaPrizeTypeEnum.THANKS.type, (Object)DuibaPrizeTypeEnum.TRY_AGAIN.type, (Object)DuibaPrizeTypeEnum.LUCK_BAG.type);
    }
}

