package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.wechat.MpUserinfoData;
import cn.com.duiba.projectx.sdk.wechat.WxAuthorizerData;
import cn.com.duiba.projectx.sdk.wechat.WxReplyConfigData;
import cn.com.duiba.projectx.sdk.wechat.WxSceneIdGenParam;
import cn.com.duiba.projectx.sdk.wechat.WxSceneRecordData;

/**
 * 微信接口
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: WechatApi.java , v 0.1 2019-10-31 16:50 ZhouFeng Exp $
 */
public interface WechatApi {

    /**
     * 获取场景值
     * 分享时初始化分享数据，用于生成带参二维码
     *
     * @param param
     * @return
     */
    Long getSceneId(WxSceneIdGenParam param);


    /**
     * 插入微信事件回复内容配置
     *
     * @param data
     * @return
     */
    Long insert(WxReplyConfigData data);


    /**
     * 获取公众号下用户信息
     *
     * @param wechatAppId 微信公众号ID
     * @param openId      用户openID
     * @return 用户信息, 可能返回null
     */
    MpUserinfoData getUserinfo(String wechatAppId, String openId);


    /**
     * 获取公众号授权APP下用户信息
     *
     * @param consumerId 兑吧consumerID
     * @return 用户信息, 可能返回null
     */
    MpUserinfoData getUserInfo(Long consumerId);

    /**
     * 获取授权方信息
     *
     * @param duibaAppId 兑吧appId
     * @return
     */
    WxAuthorizerData getAuthorizerByAppId(Long duibaAppId);

    /**
     * 根据场景码获取实体类
     *
     * @param sceneId 场景值
     * @return 实体类
     */
    WxSceneRecordData getBySceneId(Long sceneId);

    /**
     * 查询用户绑定的openId
     * <p>
     * 该接口适用于从wechat授权登录的用户，在业务中绑定了手机号，然后用手机号作为uid进行免登
     *
     * @param consumerId 用户ID
     * @return openId 可能返回null
     */
    String getBindOpenId(Long consumerId);

}
