package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.data.ConsumerCreditsLogParamData;
import cn.com.duiba.projectx.sdk.data.CreditsParamData;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: ConsumerCreditApi.java , v 0.1 2019-12-14 15:40 ZhouFeng Exp $
 */
public interface ConsumerCreditApi {
    /**
     * 条件查询积分
     *
     * @param param 参数
     * @return 积分
     */
    Long getCredits(ConsumerCreditsLogParamData param);

    /**
     * 扣减拖管积分
     * 注意：此方法只针对兑吧拖管积分
     * 调credits-center接口扣减拖管积分
     * @param creditsParamData
     * @return
     */
    Boolean subTrustCredits(CreditsParamData creditsParamData);

    /**
     * 增加拖管积分
     * 注意：此方法只针对兑吧拖管积分
     * 调credits-center接口增加拖管积分
     * @param creditsParamData
     * @return
     */
    Boolean addTrustCredits(CreditsParamData creditsParamData);

    /**
     * 查询拖管积分
     * 注意：此方法只针对兑吧拖管积分
     * 调credits-center接口查询拖管积分
     * @param userId
     * @return
     */
    Long queryTrustCreditsByConsumerId(String userId);
}
