package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.pay.abc.AbcPayApi;
import cn.com.duiba.projectx.sdk.pay.boc.BocPayApi;
import cn.com.duiba.projectx.sdk.pay.ccb.CcbPayApi;
import cn.com.duiba.projectx.sdk.pay.citic.CiticPayApi;
import cn.com.duiba.projectx.sdk.pay.icbc.IcbcPayApi;

/**
 * @author liugq
 * @date 2020/03/22
 */
public interface PayApi {

    /**
     * 微信支付
     */
    WxPayApi getWxPayApi();

    /**
     * 支付宝支付
     * @return
     */
    AliPayApi getAliPayApi();

    /**
     * 中国银行支付
     * @return BocPayApi
     */
    BocPayApi getBocPayApi();

    /**
     * 农行支付
     * @return
     */
    AbcPayApi getAbcPayApi();

    /**
     * 建行支付
     * @return
     */
    CcbPayApi getCcbPayApi();

    /**
     * 中信银行支付
     * @return
     */
    CiticPayApi getCiticPayApi();

    /**
     * 工行e支付H5
     * @return
     */
    IcbcPayApi getIcbcPayApi();
}
