package cn.com.duiba.projectx.sdk.component.bindphone;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.bindphone.dto.BindPhoneDto;
import cn.com.duiba.projectx.sdk.component.bindphone.dto.SendSmsCodeResponseDto;
import cn.com.duiba.projectx.sdk.component.bindphone.param.BindPhoneParam;
import cn.com.duiba.projectx.sdk.component.bindphone.param.SendSmsCodeParam;

/**
 * @program: projectx
 * @description: 手机号绑定api
 * @author: Simba
 * @create: 2021-03-13 19:26
 **/
public interface BindPhoneApi extends UserRequestApi {

    /**
     * 接口内部不作防刷处理，由业务方决定
     * 发送验证码
     * <p>
     * 验证码只要在重试范围内，就可以重新生成并发送,以最新生成的验证码为准进行验证，旧验证码失效。
     */
    SendSmsCodeResponseDto sendSmsCode(SendSmsCodeParam param);

    /**
     * 接口内部不作单用户高刷处理，由业务方决定
     * <p>
     * 校验验证码是否通过
     * 判断在有效的时间段内是否存在匹配的验证码
     * 校验通过后直接当前验证码直接失效
     */
    boolean bindPhone(BindPhoneParam param);

    /**
     * 查询手机号信息
     * by phoneNum
     * by userId
     */
    BindPhoneDto findBindPhone(String playwayId, String userId, String phoneNumber);
}

