package cn.com.duiba.projectx.sdk.component.checkin;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.checkin.dto.CheckinQueryResult;
import cn.com.duiba.projectx.sdk.component.checkin.dto.CheckinResult;
import cn.com.duiba.projectx.sdk.component.sendprize.dto.OptionResult;

import java.util.Date;
import java.util.List;

public interface CheckinApi extends UserRequestApi {

    /**
     * 查询奖品
     *
     * @param playwayId 玩法ID
     * @return
     */
    List<OptionResult> queryOptions(String playwayId);

    /**
     * 签到, 不发奖
     *
     * @param playwayId 玩法ID
     * @return
     */
    CheckinResult doSign(String playwayId);

    /**
     * 签到, 不发奖
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @param signTime 签到时间
     * @return
     */
    CheckinResult doSign(String playwayId, String userId, Date signTime);

    /**
     * 发奖
     *
     * @param playwayId 玩法ID
     * @return
     */
    CheckinResult sendPrize(String playwayId);

    /**
     * 发奖
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @param signTime 签到时间
     * @return
     */
    CheckinResult sendPrize(String playwayId, String userId, Date signTime);

    /**
     * 查询
     *
     * @param playwayId 玩法ID
     * @return
     */
    CheckinQueryResult query(String playwayId);

    /**
     * 查询
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @param intervalType 查询类型,默认:0
     *                     -1=上个周期
     *                     0=当前周期
     * @return
     */
    CheckinQueryResult query(String playwayId, String userId, Integer intervalType);
}
