package cn.com.duiba.projectx.sdk.component.exchange;

import cn.com.duiba.projectx.sdk.StrategyResult;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.exchange.dto.ExchangeAuthDto;
import cn.com.duiba.projectx.sdk.component.exchange.dto.ExchangeLimitInfoDto;
import cn.com.duiba.projectx.sdk.component.exchange.param.DoExchangeParam;
import cn.com.duiba.projectx.sdk.component.exchange.param.ExchangeAuthParam;

/**
 * @program: projectx
 * @description: 组件化 - 兑换组件
 * @author: Simba
 * @create: 2021-02-19 17:18
 **/
public interface ExchangeApi extends UserRequestApi {

    /**
     * 兑换条件及商品列表
     *
     * @param playwayId 玩法id
     * @return
     */
    ExchangeLimitInfoDto listExchangeLimit(String playwayId);

    /**
     * 玩法下指定规则id的权限
     *
     * @param param
     * @return
     */
    ExchangeAuthDto exchangeAuth(ExchangeAuthParam param);

    /**
     * 使用兑换玩法id及指定发奖规则id兑换
     *
     * @param param
     * @return
     */
    StrategyResult doExchange(DoExchangeParam param);

}

