package cn.com.duiba.projectx.sdk.component.exchange;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.component.exchange.param.DoExchangeParam;
import cn.com.duiba.projectx.sdk.component.exchange.param.ExchangeAuthParam;
import cn.com.duiba.projectx.sdk.component.exchange.vo.ExchangeAuthResult;
import cn.com.duiba.projectx.sdk.component.exchange.vo.ExchangeLimitInfoResult;
import cn.com.duiba.projectx.sdk.component.exchange.vo.ExchangeResult;

/**
 * @program: projectx
 * @description: 组件化 - 兑换组件玩法
 * @author: Simba
 * @create: 2021-02-23 18:56
 **/
public abstract class ExchangeComponent {

    /**
     * 查询该兑换组件玩法及商品列表
     * {@link ExchangeApi#listExchangeLimit(String)}
     */
    public abstract ExchangeLimitInfoResult listExchangeLimit(UserRequestContext context, ExchangeApi api);

    /**
     * 该玩法下指定商品的兑换权限
     * {@link ExchangeApi#exchangeAuth(ExchangeAuthParam)}
     */
    public abstract ExchangeAuthResult exchangeAuth(ExchangeAuthParam param, UserRequestContext context, ExchangeApi api);

    /**
     * 使用兑换玩法id兑换
     * {@link ExchangeApi#doExchange(DoExchangeParam)}
     */
    public abstract ExchangeResult doExchange(DoExchangeParam param, UserRequestContext context, ExchangeApi api);
}