package cn.com.duiba.projectx.sdk.component.inviteassist;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.component.inviteassist.dto.*;
import cn.com.duiba.projectx.sdk.playway.base.PlaywayCommonConfig;
import cn.com.duiba.projectx.sdk.utils.PageList;

/**
 * 邀请助力玩法
 */
public abstract class InviteAssistComponent {

    /**
     * 分享
     *  请调用 api.getInviteCode()
     * @param context
     * @param api
     * @return
     */
    public abstract InviteResult getInviteCode(UserRequestContext context, InviteAssistApi api);

    /**
     * 分享
     *  请调用 api.doAssist()
     * @param context
     * @param api
     * @return
     */
    public abstract AssistResult doAssist(AssistParam param, UserRequestContext context, InviteAssistApi api);

    /**
     * 分享查询
     *  请调用 api.queryTodayInviteRecords() or api.queryAllInviteRecords()
     * @param context
     * @param api
     * @return
     */
    public abstract PageList<InviteRecordResult> queryInviteRecords(InviteAssistQueryParam param, UserRequestContext context, InviteAssistApi api);

    /**
     * 分享查询
     *  请调用 api.queryTodayAssistRecords() or api.queryAllAssistRecords()
     * @param context
     * @param api
     * @return
     */
    public abstract PageList<AssistRecordResult> queryAssistRecords(InviteAssistQueryParam param, UserRequestContext context, InviteAssistApi api);

}
