package cn.com.duiba.projectx.sdk.component.bindphone;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.component.ActionParam;
import cn.com.duiba.projectx.sdk.component.bindphone.param.BindPhoneParam;
import cn.com.duiba.projectx.sdk.component.bindphone.param.SendSmsCodeParam;
import cn.com.duiba.projectx.sdk.component.bindphone.vo.SendSmsCodeResponseResult;

/**
 * @program: projectx
 * @description: 组件化 - 手机号绑定组件玩法
 * @author: Simba
 * @create: 2021-03-18 16:56
 **/
public abstract class BindPhoneComponent {

    /**
     * 发送验证码
     * <p>
     * 验证码只要在重试范围内，就可以重新生成并发送,以最新生成的验证码为准进行验证，旧验证码失效。
     *
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    abstract SendSmsCodeResponseResult sendSmsCode(@ActionParam SendSmsCodeParam param, UserRequestContext context, BindPhoneApi api);

    /**
     * <p>
     * 校验验证码是否通过
     * 判断在有效的时间段内是否存在匹配的验证码
     * 校验通过后直接当前验证码直接失效
     *b
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    abstract boolean bindPhone(@ActionParam BindPhoneParam param, UserRequestContext context, BindPhoneApi api);
}

