package cn.com.duiba.projectx.sdk.component.grade;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.grade.dto.GradeConfigResult;
import cn.com.duiba.projectx.sdk.component.grade.dto.GradePrizeResult;
import cn.com.duiba.projectx.sdk.component.grade.dto.GradeResult;
import cn.com.duiba.projectx.sdk.component.grade.dto.GradeSpProduce;

import java.util.List;
import java.util.Map;

public interface GradeApi extends UserRequestApi {

    /**
     * 获取等级配置
     *
     * @param playwayId 玩法ID
     * @return
     */
    List<GradeConfigResult> queryGradeConfig(String playwayId);

    /**
     * 获取用户当前等级的货币产出
     *
     * @param playwayId 玩法ID
     * @return
     */
    Map<String, GradeSpProduce> getGradeSpProduce(String playwayId, String userId);

    /**
     * 提交经验值
     *  注意用户并发提交
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @param score 经验值
     * @return
     */
    GradeResult submitScore(String playwayId, String userId, int score);

    /**
     * 发奖
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @param gradeId 等级ID
     * @return
     */
    GradePrizeResult sendPrize(String playwayId, String userId, Integer gradeId);

    /**
     * 查询等级
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    GradeResult queryGrade(String playwayId, String userId);
}
