package cn.com.duiba.projectx.sdk.component.task;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.task.dto.TaskQueryResult;
import cn.com.duiba.projectx.sdk.component.task.dto.TaskResult;

import java.util.List;

public interface TaskApi extends UserRequestApi {

    /**
     * 查询配置的任务列表
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    List<TaskQueryResult> queryTasks(String playwayId, String userId);

    /**
     * 完成任务
     *  请调用 api.doComplete()
     * @param playwayId
     * @param userId
     * @param taskId
     * @return
     */
    TaskResult doComplete(String playwayId, String userId, Integer taskId);

    /**
     * 领取奖励
     *
     * @param playwayId
     * @param userId
     * @param taskId
     * @return
     */
    TaskResult sendPrize(String playwayId, String userId, Integer taskId);

}
