package cn.com.duiba.projectx.sdk.playway.pet;

import com.alibaba.fastjson.JSONObject;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * @author zhangruofan
 * @date 2020/08/17
 */
public class PetProperties {


    @NotNull(message = "宠物类型不能为空")
    private Integer petType;

    @NotNull(message = "宠物名称不能为空")
    @Size(max = 30, min = 1, message = "宠物名称不能超过30个字")
    private String petName;

    @Max(value = 999999, message = "积分不能超过999999")
    @Min(value = 1, message = "积分不能小于1")
    private Integer adoptConsumptionQuantity;

    @Valid
    private List<Status> statusList;

    @Valid
    private GradeConfig gradeConfig;

    public Integer getPetType() {
        return petType;
    }

    public void setPetType(Integer petType) {
        this.petType = petType;
    }

    public String getPetName() {
        return petName;
    }

    public void setPetName(String petName) {
        this.petName = petName;
    }

    public Integer getAdoptConsumptionQuantity() {
        return adoptConsumptionQuantity;
    }

    public void setAdoptConsumptionQuantity(Integer adoptConsumptionQuantity) {
        this.adoptConsumptionQuantity = adoptConsumptionQuantity;
    }

    public List<Status> getStatusList() {
        return statusList;
    }

    public void setStatusList(List<Status> statusList) {
        this.statusList = statusList;
    }

    public GradeConfig getGradeConfig() {
        return gradeConfig;
    }

    public void setGradeConfig(GradeConfig gradeConfig) {
        this.gradeConfig = gradeConfig;
    }

    public static class Status {
        public static final int INIT = 0;

        public static final int PARSE = 1;

        public static final int FINISH = 2;

        @NotNull(message = "statusId不能为空")
        private Integer statusId;

        @NotNull(message = "状态名称不能为空")
        @Size(min = 1, max = 30, message = "状态名称不能超过30个字")
        private String statusName;

        @NotNull
        private Boolean isDefault = false;

        @NotNull
        private Boolean changeable = false;

        @Max(value = 999999, message = "状态持续时间不能超过999999")
        @Min(value = 0, message = "状态持续时间不能小于0")
        private Integer duration;

        @NotNull
        private Boolean interruptible;

        @Max(value = 999999, message = "间隔时间不能超过999999")
        @Min(value = 1, message = "间隔不能小于1")
        private Integer triggerInterval;

        @Valid
        private List<LimitConfig> limitConfig;

        @Valid
        private Consumption consumption;

        @Valid
        private Output output;

        public Boolean getChangeable() {
            return changeable;
        }

        public void setChangeable(Boolean changeable) {
            this.changeable = changeable;
        }

        public Output getOutput() {
            return output;
        }

        public void setOutput(Output output) {
            this.output = output;
        }

        public Integer getStatusId() {
            return statusId;
        }

        public void setStatusId(Integer statusId) {
            this.statusId = statusId;
        }

        public String getStatusName() {
            return statusName;
        }

        public void setStatusName(String statusName) {
            this.statusName = statusName;
        }

        public Boolean getDefault() {
            return isDefault;
        }

        public void setDefault(Boolean aDefault) {
            isDefault = aDefault;
        }

        public Integer getDuration() {
            return duration == null ? 0 : duration;
        }

        public void setDuration(Integer duration) {
            this.duration = duration;
        }

        public Boolean getInterruptible() {
            return interruptible;
        }

        public void setInterruptible(Boolean interruptible) {
            this.interruptible = interruptible;
        }

        public Integer getTriggerInterval() {
            return triggerInterval;
        }

        public void setTriggerInterval(Integer triggerInterval) {
            this.triggerInterval = triggerInterval;
        }

        public List<LimitConfig> getLimitConfig() {
            return limitConfig;
        }

        public void setLimitConfig(List<LimitConfig> limitConfig) {
            this.limitConfig = limitConfig;
        }

        public Consumption getConsumption() {
            return consumption;
        }

        public void setConsumption(Consumption consumption) {
            this.consumption = consumption;
        }
    }

    public static class Consumption {
        public static final int TYPE_SP = 1;
        public static final int TYPE_CREDITS = 2;
        /**
         * 1 道具
         */
        @NotNull(message = "消耗类型不能为空")
        @Max(value = 2, message = "消耗只支持道具（1）和积分（2）")
        @Min(value = 1, message = "消耗只支持道具（1）和积分（2）")
        private Integer type;

        /**
         * 道具id
         * sp_1
         */
        private String typeId;

        private Integer quantity;

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getTypeId() {
            return typeId;
        }

        public void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        public Integer getQuantity() {
            return quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }
    }

    public static class LimitConfig {
        public static final int DAILY_LIMIT = 1;
        /**
         * 1.次/日
         */
        @NotNull(message = "限制类型不能为空")
        @Max(value = 1, message = "只支持次/日（1）")
        @Min(value = 1, message = "只支持次/日（1）")
        private Integer type;


        @NotNull(message = "限制次数不能为空")
        @Max(value = 999999, message = "限制次数不能超过999999")
        @Min(value = 1, message = "限制次数不能小于1")
        private Integer times;

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Integer getTimes() {
            return times;
        }

        public void setTimes(Integer times) {
            this.times = times;
        }
    }

    public static class Output {
        public static final int INIT = 0;
        public static final int PAUSE = 1;
        public static final int UNCLAIMED = 2;
        public static final int FINISHED = 3;
        @NotNull(message = "产出类型不能为空")
        @Min(value = 1, message = "产出类型只支持道具(1)")
        @Max(value = 1, message = "产出类型只支持道具(1)")
        private Integer type;

        @NotNull(message = "id不能为空")
        private String typeId;

        @Max(value = 999999, message = "产出数量不能超过999999")
        @Min(value = 1, message = "产出数量不能小于1")
        private Integer quantity;

        @Max(value = 999999, message = "产出上限不能超过999999")
        @Min(value = 1, message = "产出上限不能小于1")
        private Integer upperLimit;

        @Max(value = 999999, message = "间隔时间不能超过999999")
        @Min(value = 1, message = "间隔时间不能小于1")
        private Integer duration;

        private Integer rate;

        public Integer getRate() {
            return rate;
        }

        public void setRate(Integer rate) {
            this.rate = rate;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getTypeId() {
            return typeId;
        }

        public void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        public Integer getQuantity() {
            return quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public Integer getUpperLimit() {
            return upperLimit;
        }

        public void setUpperLimit(Integer upperLimit) {
            this.upperLimit = upperLimit;
        }

        public Integer getDuration() {
            return duration == null ? 0 : duration;
        }

        public void setDuration(Integer duration) {
            this.duration = duration;
        }
    }

    public static class GradeConfig {
        @Valid
        private List<ExpProperties> expProperties;
        @Valid
        private List<GradeProperties> gradeProperties;

        public List<ExpProperties> getExpProperties() {
            return expProperties;
        }

        public void setExpProperties(List<ExpProperties> expProperties) {
            this.expProperties = expProperties;
        }

        public List<GradeProperties> getGradeProperties() {
            return gradeProperties;
        }

        public void setGradeProperties(List<GradeProperties> gradeProperties) {
            this.gradeProperties = gradeProperties;
        }
    }

    public static class GradeProperties {

        public final static int INFINITY = -1;

        private Integer grade;

        private String gradeName;

        private Integer upperLimit;

        @Valid
        private List<Upgrade> upgrade;

        public Integer getGrade() {
            return grade;
        }

        public void setGrade(Integer grade) {
            this.grade = grade;
        }

        public String getGradeName() {
            return gradeName;
        }

        public void setGradeName(String gradeName) {
            this.gradeName = gradeName;
        }

        public Integer getUpperLimit() {
            return upperLimit;
        }

        public void setUpperLimit(Integer upperLimit) {
            this.upperLimit = upperLimit;
        }

        public List<Upgrade> getUpgrade() {
            return upgrade;
        }

        public void setUpgrade(List<Upgrade> upgrade) {
            this.upgrade = upgrade;
        }
    }

    public static class Upgrade {

        /**
         * 王八的屁股
         */
        public static final int NULL = 0;
        public static final int SEND_PRIZE = 1;
        public static final int UNLOCK_SP = 2;
        public static final int UNLOCK_STATUS = 3;
        public static final int MODIFY_STATUS = 4;
        /**
         * 1抽奖2解锁道具3解锁状态4状态修改
         */
        @NotNull(message = "升级type类型不能为空")
        @Min(value = 0, message = "非法升级类型")
        @Max(value = 4, message = "非法升级类型")
        private Integer type;

        /**
         * {
         *  "data": {
         *      "interruptible": true,
         *      "statusId": 1,
         *      "statusName": "\u5e38\u6001",
         *      "output": {
         *          "rate": "15",
         *          "upperLimit": "1500",
         *          "type": 1,
         *          "typeId": "sp_1"
         *      },
         *      "changeable": true,
         *      "isDefault": true,
         *      "id": "1"
         *  },
         * "type": 4
         * }
         */
        private JSONObject data;

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public JSONObject getData() {
            return data;
        }

        public void setData(JSONObject data) {
            this.data = data;
        }
    }

    public static class ExpProperties {
        public static final int TYPE_SP = 1;
        /**
         * 1 道具
         */
        @NotNull(message = "类型不能为空")
        @Min(value = 1, message = "exp换算只支持道具(1)")
        @Max(value = 1, message = "exp换算只支持道具(1)")
        private Integer type;
        /**
         * sp_1
         */
        @NotNull(message = "exp类型Id不能为空")
        private String typeId;
        /**
         * 换算比例 默认1：1
         * rate = 1 1个 typeId = 1 exp
         * rate = 2 2个 typeId = 1 exp
         */
        private Integer rate = 1;

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getTypeId() {
            return typeId;
        }

        public void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        public Integer getRate() {
            return rate;
        }

        public void setRate(Integer rate) {
            this.rate = rate;
        }
    }
}
