package cn.com.duiba.projectx.sdk.component.newguide;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.component.newguide.dto.QueryNewGuideDto;
import cn.com.duiba.projectx.sdk.component.newguide.dto.StepNewGuideDto;

/**
 * @program: projectx
 * @description: 组件化 - 新手引导组件玩法
 * @author: Simba
 * @create: 2021-03-25 10:24
 **/
public abstract class NewGuideComponent {

    /**
     * 查询当前用户是否过完新手引导
     */
    abstract QueryNewGuideDto queryNewGuide(UserRequestContext context, NewGuideApi api);

    /**
     * 增加新手引导完成的步数
     *
     * @desc ⚠️接口内部不作单用户高刷处理，由业务方决定
     */
    abstract StepNewGuideDto stepNewGuide(Boolean skip, UserRequestContext context, NewGuideApi api);
}

