package cn.com.duiba.projectx.sdk.component.pendingprize;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.pendingprize.dto.PendingResult;

public interface PendingPrizeApi extends UserRequestApi {

    /**
     * 插入
     * @param playwayId
     * @param userId
     * @param type
     */
    String addAndGetCode(String playwayId, String userId, String type);

    /**
     * 插入
     * @param playwayId
     * @param userId
     * @param type
     * @param extra
     */
    String addAndGetCode(String playwayId, String userId, String type, String extra);

    /**
     * 插入
     * @param playwayId
     * @param userId
     * @param type
     * @param extra
     */
    PendingResult add(String playwayId, String userId, String type, String extra);

    /**
     * 更新为已完成
     *
     * @return
     */
    void setCompleted(String code);

    /**
     * 是否已完成
     *
     * @return true=已完成
     */
    boolean isCompleted(String code);

    /**
     * 是否已完成
     * @param playwayId
     * @param userId
     * @param type
     *
     * @return true=已完成
     */
    boolean isCompleted(String playwayId, String userId, String type);

    /**
     * 根据类型查询
     * @param playwayId
     * @param userId
     * @param type
     *
     * @return
     */
    PendingResult getByType(String playwayId, String userId, String type);
}
