package cn.com.duiba.projectx.sdk.component.answer;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.answer.dto.AnswerCompletedResult;
import cn.com.duiba.projectx.sdk.component.answer.dto.AnswerQueryResult;
import cn.com.duiba.projectx.sdk.component.answer.dto.AnswerQuestionResult;
import cn.com.duiba.projectx.sdk.component.answer.dto.AnswerStartResult;
import cn.com.duiba.projectx.sdk.component.answer.dto.AnswerSubmitResult;

public interface AnswerApi extends UserRequestApi {

    /**
     * 查询
     * @param playwayId
     * @return
     */
    AnswerQueryResult query(String playwayId);

    /**
     * 查询
     * @param playwayId
     * @return
     */
    AnswerQueryResult query(String playwayId, Integer genQuestionSize);

    /**
     * 开始答题
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param playwayId
     * @return
     */
    AnswerStartResult start(String playwayId);

    /**
     * 开始答题
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param playwayId
     * @return
     */
    AnswerStartResult start(String playwayId, String extra, Integer genQuestionSize);

    /**
     * 获取题目
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param playwayId
     * @param startId
     * @return
     */
    AnswerQuestionResult getQuestion(String playwayId, Long startId);

    /**
     * 获取题目
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param playwayId
     * @param startId
     * @return
     */
    AnswerQuestionResult getQuestion(String playwayId, String category, Long startId);

    /**
     * 提交答案
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param playwayId
     * @param startId
     * @param answer
     * @return
     */
    AnswerSubmitResult submit(String playwayId, Long startId, String answer);

    /**
     * 提交答案
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param playwayId
     * @param startId
     * @param answer
     * @param score 得分, 答对默认值:1
     *               ⚠️ 得分 >=1 算答题正确
     * @param extra
     * @return
     */
    AnswerSubmitResult submit(String playwayId, Long startId, String answer, Integer score, String extra);

    /**
     * 提交答案
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param playwayId
     * @param startId
     * @return
     */
    AnswerCompletedResult completed(String playwayId, Long startId);

}
