package cn.com.duiba.projectx.sdk.component.task;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.base.PrizeResult;
import cn.com.duiba.projectx.sdk.component.task.dto.TaskItemConfig;
import cn.com.duiba.projectx.sdk.component.task.dto.TaskQueryResult;
import cn.com.duiba.projectx.sdk.component.task.dto.TaskResult;

import java.util.Map;

public interface TaskApi extends UserRequestApi {

    /**
     * 查询配置
     *
     * @param playwayId 玩法ID
     * @return
     *  key = 任务id
     *  value = 任务配置
     */
    Map<String, TaskItemConfig> queryConfig(String playwayId);

    /**
     * 查询配置的任务列表
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    TaskQueryResult queryTasks(String playwayId, String userId);

    /**
     * 完成任务
     *  请调用 api.doComplete()
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param playwayId
     * @param userId
     * @param taskId
     * @return
     */
    TaskResult doCompleted(String playwayId, String userId, String taskId);

    /**
     * 完成任务并发奖
     *  请调用 api.doCompletedAndSendPrize()
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param playwayId
     * @param userId
     * @param taskId
     * @return
     */
    TaskResult doCompletedAndSendPrize(String playwayId, String userId, String taskId);

    /**
     * 领取奖励
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * @param playwayId
     * @param userId
     * @param taskId
     * @return
     */
    PrizeResult sendPrize(String playwayId, String userId, String taskId, String prizePendingCode);

}
