package cn.com.duiba.projectx.sdk.component.timing;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.timing.dto.TimingQueryResult;

public interface TimingApi extends UserRequestApi {

    /**
     * 查询
     * @param playwayId
     * @param timerId 计时器ID
     * @return
     */
    TimingQueryResult query(String playwayId, int timerId);

    /**
     * 查询
     * @param playwayId
     * @param userId 用户ID
     * @param timerId 计时器ID
     * @return
     */
    TimingQueryResult query(String playwayId, String userId, int timerId);

    /**
     * 启动
     * @param playwayId
     * @param timerId 计时器ID
     * @return
     */
    void start(String playwayId, int timerId);

    /**
     * 启动
     * @param playwayId
     * @param userId
     * @param timerId 计时器ID
     * @return
     */
    void start(String playwayId, String userId, int timerId);

    /**
     * 重置
     * @param playwayId
     * @param timerId 计时器ID
     * @return
     */
    void reset(String playwayId, int timerId);

    /**
     * 重置
     * @param playwayId
     * @param userId
     * @param timerId 计时器ID
     * @return
     */
    void reset(String playwayId, String userId, int timerId);

    /**
     * 是否有效
     * @param playwayId
     * @param timerId 计时器ID
     * @return
     */
    boolean valid(String playwayId, int timerId);

    /**
     * 是否有效
     * @param playwayId
     * @param userId
     * @param timerId 计时器ID
     * @return
     */
    boolean valid(String playwayId, String userId, int timerId);

}
