package cn.com.duiba.projectx.sdk.component.collectsp;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.component.base.SpResult;
import cn.com.duiba.projectx.sdk.component.collectsp.dto.CollectSpGiveResult;
import cn.com.duiba.projectx.sdk.component.collectsp.dto.CollectSpQueryResult;

/**
 * 收集道具组件玩法
 */
public abstract class CollectSpComponent {

    /**
     * 查询道具
     *  请调用 api.queryUserSps()
     * @param context
     * @param api
     * @return
     */
    public abstract CollectSpQueryResult queryUserSps(UserRequestContext context, CollectSpApi api);

    /**
     * 赠送道具
     *  请调用 api.giveSp()
     * @param context
     * @param api
     * @return
     */
    public abstract CollectSpGiveResult getSpCode(UserRequestContext context, CollectSpApi api);

    /**
     * 接收道具
     *  请调用 api.incomeSp()
     * @param context
     * @param api
     * @return
     */
    public abstract SpResult incomeSp(UserRequestContext context, CollectSpApi api);

}
