/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class CommonUtils {
    public static final String MOBILE_REG = "^1\\d{10}$";
    public static final DateTimeFormatter COMMON_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter COMMON_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter NUMBER_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final DateTimeFormatter COMMON_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter SHORT_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");

    private CommonUtils() {
    }

    public static String desensitizeMobile(String mobile) {
        if (StringUtils.isBlank((CharSequence)mobile) || !mobile.matches(MOBILE_REG)) {
            return mobile;
        }
        return mobile.replaceAll("^(\\d{3})\\d{4}(\\d{4})$", "$1****$2");
    }

    public static String desensitizeNickname(String nickname) {
        if (StringUtils.isBlank((CharSequence)nickname) || nickname.length() == 1) {
            return nickname;
        }
        StringBuilder sb = new StringBuilder(nickname.substring(0, 1));
        for (int i = 1; i < nickname.length(); ++i) {
            sb.append("*");
        }
        return sb.toString();
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static long localDateTime2Timestamp(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static LocalDateTime timestamp2LocalDateTime(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
    }

    public static long getTodayStartTimestamp() {
        return LocalDate.now().atTime(LocalTime.MIN).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getTodayEndTimestamp() {
        return LocalDate.now().atTime(LocalTime.MAX).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }
}

