package cn.com.duiba.projectx.sdk;

import cn.com.duiba.projectx.sdk.data.PhoneAreaData;
import cn.com.duiba.projectx.sdk.data.PhoneIspAreaData;
import cn.com.duiba.projectx.sdk.kww.KwwBookApi;
import cn.com.duiba.projectx.sdk.template.DistributedLock;
import cn.com.duiba.projectx.sdk.transaction.ProjectTransactionApi;
import cn.com.duiba.projectx.sdk.utils.CommonRankingApi;
import cn.com.duiba.projectx.sdk.utils.ConfigurationApi;
import cn.com.duiba.projectx.sdk.utils.CreditsApi;
import cn.com.duiba.projectx.sdk.utils.DuibaApi;
import cn.com.duiba.projectx.sdk.utils.Field;
import cn.com.duiba.projectx.sdk.utils.HttpHelper;
import cn.com.duiba.projectx.sdk.utils.KeyValueApi;
import cn.com.duiba.projectx.sdk.utils.NotifyApi;
import cn.com.duiba.projectx.sdk.utils.PrizeApi;
import cn.com.duiba.projectx.sdk.utils.QueryTable;
import cn.com.duiba.projectx.sdk.utils.QueryTableSp;
import cn.com.duiba.projectx.sdk.utils.RedisApi;
import cn.com.duiba.projectx.sdk.utils.StagePropertyApi;
import cn.com.duiba.projectx.sdk.utils.UserDataNewApi;
import cn.com.duiba.projectx.sdk.utils.UserRelationApi;
import cn.com.duiba.projectx.sdk.utils.WhiteListApi;
import org.springframework.web.client.RestTemplate;

import java.security.KeyStore;
import java.util.List;

public interface CommonApi extends Api {
    /**
     * 获取项目id
     * @return
     */
    String getProjectId();

    /**
     * 获取appId
     * @return
     */
    Long getAppId();

    /**
     * 获取配置项功能api
     * @return
     */
    ConfigurationApi getConfigurationApi();

    /**
     * 创建一个分布式锁对象
     * @param key
     * @param expireSeconds
     * @return
     */
    DistributedLock newLock(String key, int expireSeconds);

    /**
     * 获取事务功能api
     * @return
     */
    ProjectTransactionApi getTransactionApi();

    /**
     * 获取道具功能api（包含查询道具，操作道具，查询道具明细等）
     * @return
     */
    StagePropertyApi getStagePropertyApi();

    /**
     * 获取kv功能api
     * @return
     */
    KeyValueApi getKeyValueApi();

    /**
     * 获取userData功能api
     * @return
     */
    UserDataNewApi getUserDataNewApi();

    /**
     * 获取redis功能api
     * @return
     */
    RedisApi getRedisApi();

    /**
     * 获取queryTable功能api（旧）
     * @param group
     * @param clazz
     * @param <T>
     * @return
     */
    <T extends Field> QueryTable<T> getTable(String group, Class<T> clazz);

    /**
     * 获取queryTable功能api（新）
     * @param clazz
     * @param <T>
     * @return
     */
    <T> QueryTableSp<T> getQueryTableSp(Class<T> clazz);

    /**
     * 获取兑吧api
     * @return
     */
    DuibaApi getDuibaApi();

    /**
     * 获取通用排行榜api
     * @return
     */
    CommonRankingApi getCommonRankingApi();

    /**
     * 获取奖品，奖项，奖品库存，不通过发奖规则直接发奖，发奖记录等相关的api
     * @return
     */
    PrizeApi getPrizeApi();

    /**
     * 直接发积分，查询和操作托管积分等相关的api
     * @return
     */
    CreditsApi getCreditsApi();

    /**
     * 获取发送mq的api
     * @return
     */
    MqApi getMqApi();

    /**
     * 获取通知api
     * @return
     */
    NotifyApi getNotifyApi();

    /**
     * 获取白名单api
     * @return
     */
    WhiteListApi getWhiteListApi();

    /**
     * 获取用户关联api
     * @return
     */
    UserRelationApi getUserRelationApi();

    /**
     * 获取平台sdk埋点api
     * cf文档地址 http://cf.dui88.com/pages/viewpage.action?pageId=120126897
     * @return
     */
    SdkLogApi getSdkLogApi();

    /**
     * 获取HttpHelper
     * @return
     */
    HttpHelper getHttpHelper();

    /**
     * 获取一个https请求实例
     * @param key 实例的名称，不同实例间隔离
     * @param keyStore 证书
     * @return
     */
    HttpHelper getHttpHelper(String key, KeyStore keyStore);

    /**
     * 获取RestTemplate
     * @return
     */
    RestTemplate getRestTemplate();

    /**
     * 查询手机号归属地信息
     * @param phone
     * @return
     */
    PhoneAreaData queryPhoneAreaData(String phone);

    /**
     * 批量查询手机归属地查询(查询个数不能大于500，大于500返回空集合)
     * 注意：因为存在携号转网的情况，运营商信息仅供参考，业务中应该尽量避免使用运营商信息
     *
     * @param phoneList 11位的手机号码 集合
     * @return 手机归属地域
     */
    List<PhoneAreaData> findBatchPhoneArea(List<String> phoneList);

    /**
     * 手机运营商、归属地查询
     * (如果无需精确的归属地信息，无需查询此接口)
     * <p>
     * 该接口使用阿里云手机运营商、归属地查询云服务。
     * ***阿里云服务购买为1年100w次***
     * ***主要解决手机运营商不准确的问题***
     * <p>
     * 接口内部会持久化阿里云的数据，持久化规则如下:
     * 1.每次请求阿里云云服务后会持久化到本地。
     * 2.对于运营商已经变更过的用户，不再请求阿里云服务。
     * 3.对于运营商尚未变更过的用户，10天请求一次阿里云。 -> 目前兑吧内部主要是充话费，5~10天更新一次运营商，应该可以满足需求。
     *
     * @param phone 11位的手机号码
     * @return 手机归属地域
     */
    PhoneIspAreaData getPhoneIspAreaData(String phone);

    KwwBookApi getKwwBookApi();
}
