package cn.com.duiba.projectx.sdk;

import java.util.Map;

/**
 * 星速台项目上下文
 * 所有扩展的内部上下文都需要继承该接口
 * @author zhangruofan
 * @date 2020/04/21
 */
public interface ProjectContext {
    // 发放道具奖品额外信息的属性名
    String SP_PRIZE_EXTRA_CONTEXT_KEY = "SP_PRIZE_EXTRA";
    // 消耗道具额外信息的属性名
    String CONSUME_SP_EXTRA_CONTEXT_KEY = "CONSUME_SP_EXTRA";
    // 发放道具额外信息的属性名
    String GIVE_SP_EXTRA_CONTEXT_KEY = "GIVE_SP_EXTRA";
    // 当前用户为黑名单用户标记
    String BLACK_USER_FLAG = "black_user_flag";
    // 当前用户命中风控标记
    String HIT_RISK_FLAG = "hit_risk_flag";

    /**
     * get context value by key
     * @param key context key
     * @return context value
     */
    Object getValue(String key);

    /**
     * set context value
     * @param key context key
     * @param value context value
     */
    void setValue(String key, Object value);

    /**
     * get project id
     * @return project id
     */
    String getProjectId();

    /**
     * get play way id
     * @return play way id
     */
    String getPlaywayId();

    /**
     * get action id
     * @return action id
     */
    String getActionId();

    /**
     * get send prize context
     * @return send prize context
     */
    SendPrizeContext getSendPrizeContext();

    /**
     * getAttribute
     * @return
     */
    Map<String, Object> getAttribute();
}
