package cn.com.duiba.projectx.sdk.component.checkin;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.base.OptionResult;
import cn.com.duiba.projectx.sdk.component.base.PrizeResult;
import cn.com.duiba.projectx.sdk.component.checkin.dto.CheckinQueryResult;
import cn.com.duiba.projectx.sdk.component.checkin.dto.CheckinResult;
import cn.com.duiba.projectx.sdk.component.checkin.dto.SignUserRecordDTO;

import java.util.Date;
import java.util.List;

public interface CheckinApi extends UserRequestApi {

    /**
     * 查询奖品
     *
     * @param playwayId 玩法ID
     * @return
     */
    List<OptionResult> queryOptions(String playwayId);

    /**
     * 签到, 不发奖
     * ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * @param playwayId 玩法ID
     * @return
     */
    CheckinResult doSign(String playwayId);

    /**
     * 签到, 不发奖
     * ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * @param playwayId 玩法ID
     * @param userId    用户ID
     * @param signTime  签到时间
     * @return
     */
    CheckinResult doSign(String playwayId, String userId, Date signTime);

    /**
     * 签到并发奖
     * ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * @param playwayId 玩法ID
     * @param userId    用户ID
     * @param signTime  签到时间
     * @return
     */
    CheckinResult doSignAndSendPrize(String playwayId, String userId, Date signTime);

    /**
     * 发奖
     * ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * @param playwayId 玩法ID
     * @return
     */
    PrizeResult sendPrize(String playwayId);

    /**
     * 发奖
     * ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * @param playwayId 玩法ID
     * @param userId    用户ID
     * @param signTime  签到时间
     * @return
     */
    PrizeResult sendPrize(String playwayId, String userId, Date signTime);

    /**
     * 查询
     *
     * @param playwayId 玩法ID
     * @return
     */
    CheckinQueryResult query(String playwayId);

    /**
     * 查询
     *
     * @param playwayId    玩法ID
     * @param userId       用户ID
     * @param intervalType 查询类型,默认:0
     *                     -1=上个周期
     *                     0=当前周期
     * @return
     */
    CheckinQueryResult query(String playwayId, String userId, Integer intervalType);

    /**
     * 签到时间段查询
     *
     * @param playwayId 玩法ID
     * @param userId    用户ID
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @return
     */
    CheckinQueryResult query(String playwayId, String userId, Integer intervalType, Date startDate, Date endDate);

    /**
     * 查询用户签到记录
     *
     * @param playwayId
     * @param userId
     * @param startDate
     * @param endDate
     * @return
     */
    List<SignUserRecordDTO> queryUserSignRecord(String playwayId, String userId, Date startDate, Date endDate);
}
