package cn.com.duiba.projectx.sdk.component.drawprize;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.base.PrizeResult;
import cn.com.duiba.projectx.sdk.component.drawprize.dto.DrawPrizeOptionResult;
import cn.com.duiba.projectx.sdk.component.drawprize.dto.DrawPrizeQueryResult;

/**
 * 抽奖组件Api
 */
public interface DrawPrizeApi extends UserRequestApi {

    /**
     * 查询奖品配置信息
     * @param playwayId
     * @return
     */
    DrawPrizeOptionResult queryOptions(String playwayId);

    /**
     * 查询
     *
     * @param playwayId 玩法ID
     * @return
     */
    DrawPrizeQueryResult query(String playwayId, String userId);

    /**
     * 抽奖
     *
     * @param playwayId 玩法ID
     * @return
     */
    PrizeResult drawPrize(String playwayId);

    /**
     * 增加次数
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @param count 次数
     * @return
     */
    boolean addCount(String playwayId, String userId, int count);
}
