package cn.com.duiba.projectx.sdk.component.period.dto;

import java.util.List;

public class PeriodResult {

    private Long timestamp = System.currentTimeMillis();

    /**
     * 组件开始时间
     */
    private Long startTimestamp;

    /**
     * 组件结束时间
     */
    private Long endTimestamp;

    /**
     * 是否在有效期内
     * true=是
     */
    private Boolean status = false;
    /**
     * 当前场次ID
     * ⚠️ 在时间内返回
     */
    private Integer currentId;
    /**
     * 当前场次开始时间
     * ⚠️ 在时间内返回
     */
    private String currentStart;
    /**
     * 当前场次开始时间
     * ⚠️ 在时间内返回
     */
    private Long currentStartValue;
    /**
     * 当前场次结束时间
     * ⚠️ 在时间内返回
     */
    private String currentEnd;
    /**
     * 当前场次结束时间
     * ⚠️ 在时间内返回
     */
    private Long currentEndValue;
    /**
     * 总次数
     */
    private Integer totalCount;
    /**
     * 已参与次数
     */
    private Integer joinCount;
    /**
     * 剩下次数
     */
    private Integer leftCount;
    /**
     * 下场场次ID
     * ⚠️ 非循环模式不返回
     */
    private Integer nextId;
    /**
     * 下场开始时间
     * ⚠️ 非循环模式不返回
     */
    private String nextStart;
    /**
     * 下场开始时间
     * ⚠️ 非循环模式不返回
     */
    private Long nextStartValue;
    /**
     * 下场结束时间
     * ⚠️ 非循环模式不返回
     */
    private String nextEnd;
    /**
     * 下场结束时间
     * ⚠️ 非循环模式不返回
     */
    private Long nextEndValue;

    /**
     * 扩展值
     */
    private String extra;
    /**
     * 配置奖品列表
     */
    private List<PeriodOptionResult> options;
    /**
     * 配置的时间
     */
    private List<PeriodTimeResult> configTimes;
    /**
     * 参与And发奖
     */
    private Boolean awardWhenJoin;

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Long getStartTimestamp() {
        return startTimestamp;
    }

    public void setStartTimestamp(Long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Long getEndTimestamp() {
        return endTimestamp;
    }

    public void setEndTimestamp(Long endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public Boolean getStatus() {
        return status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public Integer getCurrentId() {
        return currentId;
    }

    public void setCurrentId(Integer currentId) {
        this.currentId = currentId;
    }

    public String getCurrentStart() {
        return currentStart;
    }

    public void setCurrentStart(String currentStart) {
        this.currentStart = currentStart;
    }

    public Long getCurrentStartValue() {
        return currentStartValue;
    }

    public void setCurrentStartValue(Long currentStartValue) {
        this.currentStartValue = currentStartValue;
    }

    public String getCurrentEnd() {
        return currentEnd;
    }

    public void setCurrentEnd(String currentEnd) {
        this.currentEnd = currentEnd;
    }

    public Long getCurrentEndValue() {
        return currentEndValue;
    }

    public void setCurrentEndValue(Long currentEndValue) {
        this.currentEndValue = currentEndValue;
    }

    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getJoinCount() {
        return joinCount;
    }

    public void setJoinCount(Integer joinCount) {
        this.joinCount = joinCount;
    }

    public Integer getNextId() {
        return nextId;
    }

    public void setNextId(Integer nextId) {
        this.nextId = nextId;
    }

    public String getNextStart() {
        return nextStart;
    }

    public void setNextStart(String nextStart) {
        this.nextStart = nextStart;
    }

    public Long getNextStartValue() {
        return nextStartValue;
    }

    public void setNextStartValue(Long nextStartValue) {
        this.nextStartValue = nextStartValue;
    }

    public String getNextEnd() {
        return nextEnd;
    }

    public void setNextEnd(String nextEnd) {
        this.nextEnd = nextEnd;
    }

    public Long getNextEndValue() {
        return nextEndValue;
    }

    public void setNextEndValue(Long nextEndValue) {
        this.nextEndValue = nextEndValue;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public List<PeriodOptionResult> getOptions() {
        return options;
    }

    public void setOptions(List<PeriodOptionResult> options) {
        this.options = options;
    }

    public Integer getLeftCount() {
        return leftCount;
    }

    public void setLeftCount(Integer leftCount) {
        this.leftCount = leftCount;
    }

    public List<PeriodTimeResult> getConfigTimes() {
        return configTimes;
    }

    public void setConfigTimes(List<PeriodTimeResult> configTimes) {
        this.configTimes = configTimes;
    }

    public Boolean getAwardWhenJoin() {
        return awardWhenJoin;
    }

    public void setAwardWhenJoin(Boolean awardWhenJoin) {
        this.awardWhenJoin = awardWhenJoin;
    }
}
