package cn.com.duiba.projectx.sdk.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

public enum BooleanEnum {
    FALSE(0, "false"),
    TRUE(1, "true"),
    ;

    private int code;
    private String desc;

    BooleanEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final ImmutableMap<Integer, BooleanEnum> ALL_MAP;
    static {
        Map<Integer, BooleanEnum> tmpMap = Maps.newHashMap();
        for(BooleanEnum tmpEnum : BooleanEnum.values()) {
            tmpMap.put(tmpEnum.getCode(), tmpEnum);
        }
        ALL_MAP = ImmutableMap.copyOf(tmpMap);
    }

    public static BooleanEnum getByCode(Integer code) {
        return ALL_MAP.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
