package cn.com.duiba.projectx.sdk.pay;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author zhangdaqing
 * @Description
 * @date 2024/6/19 12:34
 */
public class WxTransferDetailReq implements Serializable {
    /**
     * 商家明细单号
     * 说明：商户系统内部区分转账批次单下不同转账明细单的唯一标识，要求此参数只能由数字、大小写字母组成
     * 必填，string(32)
     */
    @NotBlank(message = "outDetailNo must not be null")
    @Size(max = 32, message = "outDetailNo不能超过32")
    private String outDetailNo;

    /**
     * 转账金额
     * 说明：转账金额单位为“分”
     * 必填
     */
    @NotNull(message = "transferAmount must not be null")
    private Long transferAmount;

    /**
     * 转账备注
     * 说明：单条转账备注（微信用户会收到该备注），UTF8编码，最多允许32个字符
     * 必填，string(32)
     */
    @NotBlank(message = "transferRemark must not be null")
    @Size(max = 32, message = "transferRemark不能超过32")
    private String transferRemark;

    /**
     * 收款用户openid
     * 说明：商户appid下，某用户的openid
     * 必填，string(64)
     */
    @NotBlank(message = "openId must not be null")
    @Size(max = 64, message = "openId不能超过64")
    private String openId;

    /**
     * 收款用户姓名
     * 说明：收款方姓名。支持标准RSA算法和国密算法，公钥由微信侧提供 明细转账金额<0.3元时，不允许填写收款用户姓名 明细转账金额 >=
     * 2,000元时，该笔明细必须填写收款用户姓名 同一批次转账明细中的姓名字段传入规则需保持一致，也即全部填写、或全部不填写
     * 若商户传入收款用户姓名，微信支付会校验用户openID与姓名是否一致，并提供电子回单
     * 选填，string(1024)
     */

    @Size(max = 1024, message = "userName不能超过1024")
    private String userName;

    public String getOutDetailNo() {
        return outDetailNo;
    }

    public void setOutDetailNo(String outDetailNo) {
        this.outDetailNo = outDetailNo;
    }

    public Long getTransferAmount() {
        return transferAmount;
    }

    public void setTransferAmount(Long transferAmount) {
        this.transferAmount = transferAmount;
    }

    public String getTransferRemark() {
        return transferRemark;
    }

    public void setTransferRemark(String transferRemark) {
        this.transferRemark = transferRemark;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}
