package cn.com.duiba.projectx.sdk.pay.cmb;

/**
 * 招商银行-掌上生活-H5支付
 *
 * @author songp
 * @date 2024/2/19 2:37 下午
 */
public interface CmbLifePayApi {

    /**
     * 发起支付
     *
     * @param request 支付请求
     * @return 响应
     */
    CmbLifePayResponse createCmbLifePayCharge(CmbLifePayReq request);

    /**
     * 支付结果通知解析
     *
     * @param bodyStr 支付结果
     * @return 解析结果
     */
    CmbLifePayNotifyResp orderNotify(String bodyStr);

    /**
     * 发起退款
     *
     * @param request 发起退款
     * @return 退款结果
     */
    CmbLifeRefundResp createRefund(CmbLifeRefundReq request);

    /**
     * 支付结果查询
     *
     * @param request 请求参数
     * @return 查询结果
     */
    CmbLifePayQueryResp payQuery(CmbLifePayQueryReq request);

    /**
     * 退款结果查询
     *
     * @param request 请求参数
     * @return 查询结果
     */
    CmbLifeRefundQueryResp refundQuery(CmbLifeRefundQueryReq request);

}
