package cn.com.duiba.projectx.sdk.pay.union.qrcode;

import java.io.Serializable;

/**
 * 深圳银联-用户主动扫码支付-预下单响应
 *
 * @author liuyanghong
 */
public class SzQrcodePayResponse implements Serializable {

    /**
     * 接口请求成功
     */
    private final static String REQUEST_SUCCESS = "0";

    /**
     * 支付请求成功
     */
    private final static String CHARGE_SUCCESS = "0";


    /**
     * 0 表示成功，非 0 表示失败此字段是通信标识，非交易标识，交易是
     * 否成功需要查看 result_code 来判断
     */
    private String status;


    /**
     * 返回信息，如非空，为错误原因签名失败参数格式校验错误
     */
    private String message;


    /**
     * 返回信息，如非空，为错误原因签名失败参数格式校验错误
     */
    private String resultCode;


    /**
     * 错误描述
     */
    private String errMsg;

    /**
     * 可直接生成二维码展示出来进行扫码支付，也可以在浏览器访问
     */
    private String codeUrl;


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getCodeUrl() {
        return codeUrl;
    }

    public void setCodeUrl(String codeUrl) {
        this.codeUrl = codeUrl;
    }


    /**
     * 支付预下单是否成功
     *
     * @return true: 成功
     */
    public boolean isSuccess() {
        return REQUEST_SUCCESS.equals(this.status) && CHARGE_SUCCESS.equals(this.resultCode);
    }
}
