package cn.com.duiba.projectx.sdk.pay.wxv3;

/**
 * 请求的body参数
 */
public class ConfirmTransferNotifyBody {
    /**
     * 【通知ID】通知的唯一ID
     */
    private String id;
    /**
     * 【通知创建时间】通知创建的时间，遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss.表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示北京时间2015年05月20日13点29分35秒。
     */
    private String create_time;
    /**
     * 【通知数据类型】通知的资源数据类型，商家转账通知为encrypt-resource
     */
    private String resource_type;
    /**
     * 【通知类型】通知的类型，商家转账通知的类型为MCHTRANSFER.BILL.FINISHED
     */
    private String event_type;
    /**
     * 【回调摘要】回调摘要
     */
    private String summary;
    /**
     * 【通知数据】json格式
     */
    private Resource resource;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCreate_time() {
        return create_time;
    }

    public void setCreate_time(String create_time) {
        this.create_time = create_time;
    }

    public String getResource_type() {
        return resource_type;
    }

    public void setResource_type(String resource_type) {
        this.resource_type = resource_type;
    }

    public String getEvent_type() {
        return event_type;
    }

    public void setEvent_type(String event_type) {
        this.event_type = event_type;
    }

    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Resource getResource() {
        return resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public static class Resource {
        /**
         * 【原始类型】原始回调类型，为mch_payment
         */
        private String original_type;
        /**
         * 【加密算法类型】对开启结果数据进行加密的加密算法，目前只支持AEAD_AES_256_GCM
         */
        private String algorithm;
        /**
         * 【数据密文】Base64编码后的商家转账结果数据密文
         */
        private String ciphertext;
        /**
         * 【附加数据】附加数据
         */
        private String associated_data;
        /**
         * 【随机串】加密使用的随机串。
         */
        private String nonce;

        public void setOriginal_type(String original_type) {
            this.original_type = original_type;
        }

        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public void setCiphertext(String ciphertext) {
            this.ciphertext = ciphertext;
        }

        public void setAssociated_data(String associated_data) {
            this.associated_data = associated_data;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public String getOriginal_type() {
            return original_type;
        }

        public String getAlgorithm() {
            return algorithm;
        }

        public String getCiphertext() {
            return ciphertext;
        }

        public String getAssociated_data() {
            return associated_data;
        }

        public String getNonce() {
            return nonce;
        }
    }
}
