package cn.com.duiba.projectx.sdk.pay.wxv3.resp;

/**
 * ConfirmTransferResponse
 */
public class ConfirmTransferQueryResponse {
    /**
     * 【商户号】 微信支付分配的商户号
     */
    private String mch_id;
    /**
     * 【商户单号】 商户系统内部的商家单号，要求此参数只能由数字、大小写字母组成，在商户系统内部唯一
     */
    private String out_bill_no;
    /**
     * 【商家转账订单号】 商家转账订单的主键，唯一定义此资源的标识
     */
    private String transfer_bill_no;
    /**
     * 【商户AppID】 是微信开放平台和微信公众平台为开发者的应用程序(APP、小程序、公众号、企业号corpid即为此AppID)提供的一个唯一标识。此处，可以填写这四种类型中的任意一种APPID，但请确保该appid与商户号有绑定关系。详见：普通商户模式开发必要参数说明
     */
    private String appid;
    /**
     * 【单据状态】
     * <p>
     * 可选取值
     * <p>
     * ACCEPTED: 转账已受理
     * <p>
     * PROCESSING: 转账锁定资金中。如果一直停留在该状态，建议检查账户余额是否足够，如余额不足，可充值后再原单重试。
     * <p>
     * WAIT_USER_CONFIRM: 待收款用户确认，可拉起微信收款确认页面进行收款确认
     * <p>
     * TRANSFERING: 转账中，可拉起微信收款确认页面再次重试确认收款
     * <p>
     * SUCCESS: 转账成功
     * <p>
     * FAIL: 转账失败
     * <p>
     * CANCELING: 商户撤销请求受理成功，该笔转账正在撤销中
     * <p>
     * CANCELLED: 转账撤销完成
     */
    private String state;
    /**
     * 【转账金额】 转账金额单位为“分”。
     */
    private Integer transfer_amount;
    /**
     * 【转账备注】 单条转账备注（微信用户会收到该备注），UTF8编码，最多允许32个字符
     */
    private String transfer_remark;
    /**
     * 【失败原因】 订单已失败或者已退资金时，会返回订单失败原因
     */
    private String fail_reason;
    /**
     * 【收款用户OpenID】 用户在商户appid下的唯一标识。发起转账前需获取到用户的OpenID
     */
    private String openid;
    /**
     * 【收款用户姓名】 收款方真实姓名。支持标准RSA算法和国密算法，公钥由微信侧提供转账金额 >= 2,000元时，该笔明细必须填写若商户传入收款用户姓名，微信支付会校验用户OpenID与姓名是否一致，并提供电子回单
     */
    private String user_name;
    /**
     * 【单据创建时间】 单据受理成功时返回，按照使用rfc3339所定义的格式，格式为yyyy-MM-DDThh:mm:ss+TIMEZONE
     */
    private String create_time;
    /**
     * 【最后一次状态变更时间】 单据最后更新时间，按照使用rfc3339所定义的格式，格式为yyyy-MM-DDThh:mm:ss+TIMEZONE
     */
    private String update_time;

    public String getMch_id() {
        return mch_id;
    }

    public void setMch_id(String mch_id) {
        this.mch_id = mch_id;
    }

    public String getOut_bill_no() {
        return out_bill_no;
    }

    public void setOut_bill_no(String out_bill_no) {
        this.out_bill_no = out_bill_no;
    }

    public String getTransfer_bill_no() {
        return transfer_bill_no;
    }

    public void setTransfer_bill_no(String transfer_bill_no) {
        this.transfer_bill_no = transfer_bill_no;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Integer getTransfer_amount() {
        return transfer_amount;
    }

    public void setTransfer_amount(Integer transfer_amount) {
        this.transfer_amount = transfer_amount;
    }

    public String getTransfer_remark() {
        return transfer_remark;
    }

    public void setTransfer_remark(String transfer_remark) {
        this.transfer_remark = transfer_remark;
    }

    public String getFail_reason() {
        return fail_reason;
    }

    public void setFail_reason(String fail_reason) {
        this.fail_reason = fail_reason;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getUser_name() {
        return user_name;
    }

    public void setUser_name(String user_name) {
        this.user_name = user_name;
    }

    public String getCreate_time() {
        return create_time;
    }

    public void setCreate_time(String create_time) {
        this.create_time = create_time;
    }

    public String getUpdate_time() {
        return update_time;
    }

    public void setUpdate_time(String update_time) {
        this.update_time = update_time;
    }
}
