package cn.com.duiba.projectx.sdk.pay.wxv3.resp;


/**
 * ConfirmTransferResponse
 */
public class ConfirmTransferResponse {
    /**
     * 【商户单号】 商户系统内部的商家单号，要求此参数只能由数字、大小写字母组成，在商户系统内部唯一
     */
    private String out_bill_no;

    /**
     * 【微信转账单号】 微信转账单号，微信商家转账系统返回的唯一标识
     */
    private String transfer_bill_no;

    /**
     * 【单据创建时间】 单据受理成功时返回，按照使用rfc3339所定义的格式，格式为yyyy-MM-DDThh:mm:ss+TIMEZONE
     */
    private String create_time;

    /**
     * 【单据状态】 商家转账订单状态
     * <p>
     * 可选取值
     * <p>
     * ACCEPTED: 转账已受理
     * <p>
     * PROCESSING: 转账锁定资金中。如果一直停留在该状态，建议检查账户余额是否足够，如余额不足，可充值后再原单重试。
     * <p>
     * WAIT_USER_CONFIRM: 待收款用户确认，可拉起微信收款确认页面进行收款确认
     * <p>
     * TRANSFERING: 转账中，可拉起微信收款确认页面再次重试确认收款
     * <p>
     * SUCCESS: 转账成功
     * <p>
     * FAIL: 转账失败
     * <p>
     * CANCELING: 商户撤销请求受理成功，该笔转账正在撤销中
     * <p>
     * CANCELLED: 转账撤销完成
     * <p>
     * fail_reason 　选填 string
     * <p>
     * 【失败原因】 订单已失败或者已退资金时，会返回订单失败原因
     * <p>
     * package_info 　选填 string
     * <p>
     * 【跳转领取页面的package信息】 跳转微信支付收款页的package信息，APP调起用户确认收款或者JSAPI调起用户确认收款 时需要使用的参数。
     * <p>
     * 单据创建后，用户24小时内不领取将过期关闭，建议拉起用户确认收款页面前，先查单据状态：如单据状态为待收款用户确认，可用之前的package信息拉起；单据到终态时需更换单号重新发起转账。
     */
    private String state;

    /**
     * 【失败原因】 订单已失败或者已退资金时，会返回订单失败原因
     */
    private String fail_reason;

    /**
     * 【跳转领取页面的package信息】 跳转微信支付收款页的package信息，APP调起用户确认收款或者JSAPI调起用户确认收款 时需要使用的参数。
     * <p>
     * 单据创建后，用户24小时内不领取将过期关闭，建议拉起用户确认收款页面前，先查单据状态：如单据状态为待收款用户确认，可用之前的package信息拉起；单据到终态时需更换单号重新发起转账。
     */
    private String package_info;

    public String getOut_bill_no() {
        return out_bill_no;
    }

    public void setOut_bill_no(String out_bill_no) {
        this.out_bill_no = out_bill_no;
    }

    public String getTransfer_bill_no() {
        return transfer_bill_no;
    }

    public void setTransfer_bill_no(String transfer_bill_no) {
        this.transfer_bill_no = transfer_bill_no;
    }

    public String getCreate_time() {
        return create_time;
    }

    public void setCreate_time(String create_time) {
        this.create_time = create_time;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getFail_reason() {
        return fail_reason;
    }

    public void setFail_reason(String fail_reason) {
        this.fail_reason = fail_reason;
    }

    public String getPackage_info() {
        return package_info;
    }

    public void setPackage_info(String package_info) {
        this.package_info = package_info;
    }
}
