package cn.com.duiba.projectx.sdk.playway.base;

public interface Prize {
    int PRIZE_TYPE_THANKS = 0; // 谢谢参与
    int PRIZE_TYPE_SP = 1; // 道具奖品
    int PRIZE_TYPE_DUIBA = 2; // 兑吧奖品
    int PRIZE_TYPE_CUSTOM = 3; // 自定义奖品
    int PRIZE_TYPE_LUCKY_BAG = 4; // 福袋

    String PRIZE_REF_TYPE_INCREASE_CREDITS = "increase-credits";

    /**
     * 奖品ID
     *
     * @return
     */
    public String getId();

    /**
     * 奖品名称
     *
     * @return
     */
    String getName();

    /**
     * 奖品类型
     *
     * @return
     */
    Integer getType();

    /**
     * 关联的兑吧商品id
     * @return
     */
    String getRefId();

    /**
     * 关联的兑吧商品类型
     * @return
     */
    String getRefType();

    /**
     * 奖品库存
     *
     * @return
     */
    Long getStock();

    /**
     * 奖品图片
     *
     * @return
     */
    String getIcon();

    /**
     * 未领取时的奖品图片
     *
     * @return
     */
    String getUnclaimedIcon();

    /**
     * 跳转链接
     *
     * @return
     */
    String getUrl();

}
