package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.data.IdentityCustomerRelationData;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Description:RemoteIdentityCustomerRelationService 功能封装
 */
public interface IdentifyRelationApi {

    /**
     * 保存identityCustomerRelationData
     * @param identityCustomerRelationData identityCustomerRelationData
     * ⚠️注意 appId 和 relType 谨慎定义以免和其他业务冲突
     * 建议使用时添加到activity-customer-center的IdentityNewRelTypeEnum中
     */
    void save(IdentityCustomerRelationData identityCustomerRelationData);

    /**
     * 根据关联内容和partnerId查询用户关系数据
     * @param partnerId 兑吧用户ID
     * @param appId 应用ID
     * @param relType 关联类型<>业务自定义</>
     * @return 用户关系数据列表
     */
    List<IdentityCustomerRelationData> queryByPid( String partnerId, Long appId, Integer relType);
}
