package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.querytable.QueryWrapper;
import cn.com.duiba.projectx.sdk.querytable.SFunction;

import java.util.List;

/**
 * Author: DSG
 * Date: 11:24 2021/7/30
 * Description: QueryTable操作工具
 */
public interface QueryTableSp<T> {
    /**
     * 添加一条数据
     * @param t
     */
    void add(T t);

    /**
     * 通过id删除一条数据
     * @param id
     */
    void delete(long id);

    /**
     * 通过id修改一条数据
     * @param t
     * @return
     */
    boolean updateById(T t);

    /**
     * 通过条件修改数据
     * @param queryWrapper
     * @param t
     * @return
     */
    long update(QueryWrapper<T> queryWrapper,T t);

    /**
     * 通过id递增score值
     * @param id
     * @param delta 自增值
     * @param limit   限制, 如果是递增,则结果不能大于limit ,如果是递减,则结果不能小于limit
     * @return
     */
    boolean increment(long id, long delta, long limit);

    /**
     * 通过条件查询一条数据 *如果查出多条将报错
     * @param queryWrapper
     * @return
     */
    T queryOne(QueryWrapper<T> queryWrapper);

    /**
     * 通过一个条件查询一条数据 *如果查出多条将报错
     * @param function
     * @param o
     * @return
     */
    T queryOne(SFunction<T,?> function, Object o);

    /**
     * 通过条件查询列表 最多2000条
     * @param queryWrapper
     * @return
     */
    List<T> queryListLimit2000(QueryWrapper<T> queryWrapper);


    /**
     * 通过条件查询列表 最多2000条
     * @param queryWrapper
     * @return
     */
    List<T> queryListLimit(QueryWrapper<T> queryWrapper,Integer limit);

    /**
     * 通过一个条件查询列表, 最多2000条
     * @param function
     * @param o
     * @return
     */
    List<T> queryListLimit2000(SFunction<T,?> function, Object o);

    /**
     * 通过自定义条件翻页查询
     * @param queryWrapper
     * @param pageNum 从1开始
     * @param pageSize 最大2000
     * @return
     */
    PageList<T> pageQuery(QueryWrapper<T> queryWrapper,long pageNum, long pageSize);

    /**
     * 通过一个条件翻页查询
     * @param function
     * @param o
     * @param pageNum 从1开始
     * @param pageSize 最大2000
     * @return
     */
    PageList<T> pageQuery(SFunction<T,?> function, Object o,long pageNum, long pageSize);
    /**
     * 示例:假如是倒序查询则最终sql条件会是 where id < #{id}  order by id desc limit #{pageSize}, 当然此处的where后面的project,groupid省略了,只是作为示例.
     *   @param function 没有时可以传null,此处为null时参数value也为null
     *   @param value 筛选条件的值
     *   @param id 此参数必传
     *   @param sortType 升序or降序
     *   @param pageSize 查询的数据条数
     *   @return 分页的数据, 注意:此处的totalPage和totalCount是查的最新的数据条数,但条件查询是根据id和gmtCreate的,所以查到最后一页是有可能没有数据的.
     */
    PageList<T> pageQueryFilterByLastId(SFunction<T, ?> function, Object value, Long id, QueryTable.SortType sortType, long pageSize);

    /**
     * 查询所有记录（一般用于定时任务中，用户请求中慎用，返回列表按照id升序排列）
     * @param function 没有时可以传null，不支持SubData字段
     * @param value 筛选条件的值
     * @return
     */
    List<T> queryAll(SFunction<T, ?> function, Object value);

    /**
     * 获取一个新的条件构造对象
     * @return
     */
    QueryWrapper<T> getQueryWrapper();
    /**
     * 只查询给定的字段,建议确认能覆盖索引时才用这个进行查询,具体能否覆盖可参考tb_query_table表的索引.
     * @param function 查询条件,没有条件时可以写为null
     * @param value 查询条件的值
     * @param pageNum 从1开始
     * @param pageSize 最大2000
     * @param field 属性名称,Case Sensitive !!!  示例:比如类中使用了@Ext1标注了private String userId; 那么查询fields可以写为 "userId"
     * @return
     */
    PageList<T> queryGivenField(SFunction<T,?> function, Object value,long pageNum, long pageSize,String field);
}
