package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.pay.*;
import cn.com.duiba.projectx.sdk.pay.wxfavorsuercoupon.*;
import cn.com.duiba.projectx.sdk.pay.wxv3.req.ConfirmTransferRequest;
import cn.com.duiba.projectx.sdk.pay.wxv3.req.InitiateBatchTransferRequest;
import cn.com.duiba.projectx.sdk.pay.wxv3.resp.ConfirmTransferNotifyResponse;
import cn.com.duiba.projectx.sdk.pay.wxv3.resp.ConfirmTransferQueryResponse;
import cn.com.duiba.projectx.sdk.pay.wxv3.resp.ConfirmTransferResponse;
import cn.com.duiba.projectx.sdk.pay.wxv3.resp.InitiateBatchTransferResponse;
import cn.com.duiba.projectx.sdk.wechat.WxCouponDetail;

import javax.servlet.http.HttpServletRequest;

/**
 * @author liugq
 * @date 2020/03/22
 */
public interface WxPayApi {

    /**
     * 发起微信h5支付
     *
     * @param request
     * @return
     */
    WxWapPayResp createWxWapPay(WxWapPayReq request) throws BizRuntimeException;

    /**
     * 支付订单状态查询
     *
     * @param payRecordId
     * @return
     */
    WxPayStatus queryPayStatus(Long payRecordId) throws BizRuntimeException;

    /**
     * 发起微信公众号支付
     *
     * @param request
     * @return
     */
    WxMpPayResp createWxMpPay(WxMpPayReq request) throws BizRuntimeException;

    /**
     * 发起微信小程序支付
     *
     * @param request
     * @return
     */
    WxPayLiteResp createWxPayLitePay(WxPayLiteReq request) throws BizRuntimeException;

    /**
     * 支付结果通知
     *
     * @param xmlDataStr 1.业务方接收到回调后用下面代码，拿到字符串作为入参数
     *                   InputStream inputStream = request.getInputStream()) {
     *                   String notifyString = IOUtils.toString(inputStream);
     *                   <p>
     *                   2.业务处理后需要返回给微信处理结果，否则微信会重复通知
     *                   可直接返回参数里的两个常量： SUCCESS / FAIL
     */
    WxPayNotifyResp payOrderNotify(String xmlDataStr) throws BizRuntimeException;

    /**
     * 发起退款：成功后返回退款订单号，否则抛出异常
     *
     * @param payOrderId
     * @param callbackUrl : 退款发起后接收微信回调的url
     * @return 退款订单号
     */
    String createWxRefund(Long payOrderId, String callbackUrl) throws BizRuntimeException;

    /**
     * 发起退款：成功后返回退款订单号，否则抛出异常
     *
     * @param payOrderId
     * @param callbackUrl : 退款发起后接收微信回调的url
     * @param amount      : 退款的具体金额
     * @return 退款订单号
     */
    String createWxRefund(Long payOrderId, String callbackUrl, int amount) throws BizRuntimeException;

    /**
     * 退款结果通知
     *
     * @param xmlDataStr 1.业务方接收到回调后用下面代码，拿到字符串作为入参数
     *                   InputStream inputStream = request.getInputStream()) {
     *                   String notifyString = IOUtils.toString(inputStream);
     *                   <p>
     *                   2.业务处理后需要返回给微信处理结果，否则微信会重复通知
     *                   可直接返回参数里的两个常量： SUCCESS / FAIL
     */
    WxRefundNotifyResp refundOrderNotify(String xmlDataStr) throws BizRuntimeException;

    /**
     * 退款结果通知(自主支付模式下如需指定apiKey时使用)
     *
     * @param xmlDataStr 1.业务方接收到回调后用下面代码，拿到字符串作为入参数
     *                   InputStream inputStream = request.getInputStream()) {
     *                   String notifyString = IOUtils.toString(inputStream);
     *                   <p>
     *                   2.业务处理后需要返回给微信处理结果，否则微信会重复通知
     *                   可直接返回参数里的两个常量： SUCCESS / FAIL
     */
    WxRefundNotifyResp refundOrderNotify(String xmlDataStr, String apiKey) throws BizRuntimeException;


    /**
     * 根据银行全称，获取微信支付银行返回的银行编码
     *
     * @param bankName
     * @param type     ： 1-借记卡 2-信用卡
     * @return
     */
    String getWxPayBank(String bankName, int type);

    /**
     * 微信发放优惠券（此接口当前只支持兑吧商户号，商户id:1227739602）
     *
     * @param openId            发放openId
     * @param stockId           优惠券批次号
     * @param stockCreatorMchid 制券者商户号（发放的是自己商户的优惠券则不需要填写，若发放开发者商户号创建的优惠券，则填写开发者商户号）
     * @return
     * @throws BizRuntimeException
     */
    WxSendCouponResp sendWxCoupon(String openId, String stockId, String stockCreatorMchid) throws BizRuntimeException;

    /**
     * 微信发放优惠券(自定义金额发放时使用此接口)（此接口当前只支持兑吧商户号，商户id:1227739602）
     *
     * @param openId            发放openId
     * @param stockId           优惠券批次号
     * @param stockCreatorMchid 制券者商户号（发放的是自己商户的优惠券则不需要填写，若发放开发者商户号创建的优惠券，则填写开发者商户号）
     * @param wxCouponValue     立减金面额(单位分 微信接口目前有限制最少发放1元,最大500元)
     * @return
     * @throws BizRuntimeException
     */
    WxSendCouponResp sendWxCoupon(String openId, String stockId, String stockCreatorMchid, Integer wxCouponValue) throws BizRuntimeException;

    /**
     * 微信发放优惠券，针对定时任务或MQ接口
     *
     * @param wxSendCouponReq
     * @return
     * @throws BizRuntimeException
     */
    WxSendCouponResp sendWxCoupon(WxSendCouponReq wxSendCouponReq) throws BizRuntimeException;

    /**
     * 微信发放零钱
     *
     * @param req
     * @return
     * @throws BizRuntimeException
     */
    WxTransferPaySendResp asynWxTransfer(WxTransferPaySendReq req) throws BizRuntimeException;

    /**
     * 微信发放零钱结果查询
     *
     * @param bizOrderNo
     * @param bizRelationId
     * @param bizRelationType
     * @return
     * @throws BizRuntimeException
     */
    WxTransferPayDto queryWxTransfer(String bizOrderNo, String bizRelationId, Integer bizRelationType) throws BizRuntimeException;


    /**
     * 异步发放微信红包
     *
     * @param redPacketSendReq
     * @return
     * @throws BizRuntimeException
     */
    WxTransferPaySendResp asynSendWxRedPacket(WxPayRedPacketSendReq redPacketSendReq) throws BizRuntimeException;


    /**
     * 查询福建兑吧微信立减金的详情
     *
     * @param recordId 发奖记录Id
     * @return 使用状态
     */
    WxCouponDetail queryWxCouponDetail(String recordId) throws BizRuntimeException;

    /**
     * 根据福建兑吧券ID找到发奖记录ID
     *
     * @param couponId 券ID
     * @return 星速台发奖记录ID
     * @throws BizRuntimeException 业务异常
     */
    String findRecordIdByCouponId(String couponId) throws BizRuntimeException;

    /**
     * 根据主订单找到recordId
     *
     * @param orderNum 主订单号
     * @return 发奖记录ID
     */
    String findRecordIdByOrderNum(String orderNum);


    /**
     * 查询福建兑吧微信立减金的详情
     *
     * @param couponId 券ID
     * @param openId   用户openId
     * @throws BizRuntimeException 业务异常
     */
    WxCouponDetail findWxCouponDetail(String couponId, String openId);


    /**
     * 微信商家转账到零钱
     * <p>
     * 走的权益的功能，使用之前，需要在tb_wxpay_mch_conf_cert配置开发者微信平台的商家相关的证书信息
     * 📢 微信零钱不支持高并发操作
     *
     * @param wxTransReq
     * @return {@link WxTransResp}
     */
    WxTransResp WxTrans(WxTransReq wxTransReq);

    /**
     * 查询微信转账结果
     *
     * @param bizNo
     * @return {@link Integer}
     */
    Integer getWxTransResult(String bizNo);

    /**
     * 查询微信转账结果(包含具体成功笔数信息。存在状态成功，但是会有失败笔数的场景，如回退)
     *
     * @param bizNo
     * @return {@link WxInitiateBatchTransferResponse}
     */
    WxInitiateBatchTransferResponse getWxTransResultDetail(String bizNo);


    /**
     * 发放微信立减金（走商户证书）
     *
     * @param wxFavorUserCouponsRequest
     * @return {@link WxFavorCouponResponse}
     */
    WxFavorCouponResponse sendWxCoupon(WxFavorUserCouponsRequest wxFavorUserCouponsRequest);


    /**
     * 查询批次详情
     *
     * @param mchId             商户号
     * @param stockId           批次号
     * @param stockCreatorMchId 创建批次的商户号
     * @return 批次详情
     */
    WxFavorStocksDto getStocksInfo(String mchId, String stockId, String stockCreatorMchId);

    /**
     * 查询立减金发放结果
     *
     * @param bizNo
     * @return {@link WxCouponResultResponse}
     * couponId 不为空时代表成功
     */
    WxCouponResultResponse distributeResult(String bizNo);

    /**
     * 保存商户号信息到paycenter，具体看remote方法
     *
     * @param mchId
     * @param mchName
     * @param apiV3Key
     * @param privateKey
     * @param serialNumber
     * @param merchantCert
     * @param effectiveTime
     * @param expireTime
     * @param mchType
     * @return {@link String}
     */
    String saveMerch(String mchId, String mchName, String apiV3Key, String privateKey, String serialNumber, String merchantCert, String effectiveTime, String expireTime, Integer mchType);

    /**
     * 微信提现到零钱(旧接口，直接到账，有些商户可能不再支持调用)
     *
     * @param merchantId            微信商户号Id
     * @param privateKey            商户证书私钥
     * @param merchantSerialNumber  商户证书序列号
     * @param wechatPayCertificates 平台证书
     * @param request
     * @return
     */
    InitiateBatchTransferResponse initiateBatchTransfer(String merchantId, String privateKey, String merchantSerialNumber, String wechatPayCertificates, InitiateBatchTransferRequest request);

    /**
     * 微信转账(新接口，需要用户点击确认收款，微信提现到零钱无法使用时使用此接口)
     * https://pay.weixin.qq.com/doc/v3/merchant/4012716434
     *
     * @param merchantId            微信商户号Id
     * @param privateKey            商户证书私钥
     * @param merchantSerialNumber  商户证书序列号
     * @param wechatPayCertificates 平台证书
     * @param request
     * @return
     */
    ConfirmTransferResponse confirmTransfer(String merchantId, String privateKey, String merchantSerialNumber, String wechatPayCertificates, ConfirmTransferRequest request);

    /**
     * 微信转账查询(根据商户单号)
     * https://pay.weixin.qq.com/doc/v3/merchant/4012716437
     *
     * @param merchantId            微信商户号Id
     * @param privateKey            商户证书私钥
     * @param merchantSerialNumber  商户证书序列号
     * @param wechatPayCertificates 平台证书
     * @param outBillNo             【商户单号】 商户系统内部的商家单号，要求此参数只能由数字、大小写字母组成，在商户系统内部唯一
     * @return
     */
    ConfirmTransferQueryResponse confirmTransferQuery(String merchantId, String privateKey, String merchantSerialNumber, String wechatPayCertificates, String outBillNo);

    /**
     * 微信转账通知回调
     * https://pay.weixin.qq.com/doc/v3/merchant/4012712115
     * 商户验签后，根据验签结果对回调进行应答：
     * 验签通过：商户需告知微信支付接收回调成功，HTTP应答状态码需返回200或204，无需返回应答报文。
     * 验签不通过：商户需告知微信支付接收回调失败，HTTP应答状态码需返回5XX或4XX，同时需返回以下应答报文：
     * Body 包体参数
     * 【返回状态码】错误码，SUCCESS为接收成功，其他错误码为失败
     * 应答示例
     * {
     * "code": "SUCCESS",
     * "message": "FAILED"
     * }
     * 对后台通知交互时，如果微信收到商户的应答不符合规范或超时，微信认为通知失败，微信会通过一定的策略定期重新发起通知，尽可能提高通知的成功率，但微信不保证通知最终能成功。（通知频率为0s/15s（尝试10次）/300s（尝试10次）/1800s（尝试44次)）
     *
     * @param request              请求request
     * @param merchantId           微信商户号Id
     * @param privateKey           商户证书私钥
     * @param merchantSerialNumber 商户证书序列号
     * @param apiV3Key             apiV3密钥
     * @param request
     * @return
     */
    ConfirmTransferNotifyResponse confirmTransferNotify(HttpServletRequest request, String merchantId, String privateKey, String merchantSerialNumber, String apiV3Key);
}
