package cn.com.duiba.projectx.sdk.wechat;

import java.io.Serializable;
import java.util.Date;

/**
 * 企业微信群成员

 */
public class ChatGroupMemberOpenData implements Serializable {

    private static final long serialVersionUID = -1865925344882773466L;

    /**
     * 群成员id
     */
    private String userId;

    /**
     * 外部联系人在微信开放平台的唯一身份标识
     */
    private String unionId;

    /**
     * 加群时间
     */
    private Date joinTime;

    /**
     * 加入方式
     */
    private Integer joinScene;

    /**
     * 成员类型：0:成员 1:管理员 2:群主
     */
    private Integer chatAdmin;

    /**
     * 成员类型:1 - 企业成员;2 - 外部联系人
     */
    private Integer memberType;

    /**
     * 邀请者。目前仅当是由本企业内部成员邀请入群时会返回该值
     */
    private String invitorUserid;

    /**
     * 在群里的昵称
     */
    private String groupNickname;


    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public Date getJoinTime() {
        return joinTime;
    }

    public void setJoinTime(Date joinTime) {
        this.joinTime = joinTime;
    }

    public Integer getJoinScene() {
        return joinScene;
    }

    public void setJoinScene(Integer joinScene) {
        this.joinScene = joinScene;
    }

    public Integer getChatAdmin() {
        return chatAdmin;
    }

    public void setChatAdmin(Integer chatAdmin) {
        this.chatAdmin = chatAdmin;
    }

    public Integer getMemberType() {
        return memberType;
    }

    public void setMemberType(Integer memberType) {
        this.memberType = memberType;
    }

    public String getInvitorUserid() {
        return invitorUserid;
    }

    public void setInvitorUserid(String invitorUserid) {
        this.invitorUserid = invitorUserid;
    }

    public String getGroupNickname() {
        return groupNickname;
    }

    public void setGroupNickname(String groupNickname) {
        this.groupNickname = groupNickname;
    }
}

