/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.account;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public enum AccountTypeEnum {
    GLOBAL_REWARD("\u5168\u5c40\u7ea2\u5305", 0),
    HAND_REWARD("\u624b\u6c14\u7ea2\u5305", 1),
    PET_FEEDER("\u5ba0\u7269\u517b\u6210\u9972\u517b\u5458\u8d26\u6237", 2),
    SIGN_VIRTUAL_CARD("\u7b7e\u5230\u8865\u7b7e\u865a\u62df\u5361", 3),
    EXP("\u7ecf\u9a8c\u8d26\u6237", 4),
    FZ_GUESS("\u98de\u732a\u7ade\u731c\u5b9a\u5236\u8d26\u6237", 5),
    ALL_WALLET("\u5168\u5c40\u94b1\u5305", 6),
    AQY_WALLET("\u7231\u5947\u827a\u94b1\u5305", 7),
    PET_WANDER("\u5916\u6765\u5ba0\u7269\u7528\u6237\u8d26\u6237", 8),
    TOTAL_REWARD("\u7d2f\u8ba1\u7ea2\u5305\u8d26\u6237", 9),
    ALL_WALLET_BUDGET("\u5168\u5c40\u94b1\u5305\u9884\u7b97\u8d26\u6237", 10),
    MASTER_DISCIPLE_SYSTEM("\u767e\u59d3\u7f51\u5e08\u5f92\u4f53\u7cfb\u8d26\u6237", 11),
    LOTTERY_SQUARE("\u7ea2\u5305\u5e7f\u573a", 12),
    SHUQI_REFLUX("\u4e66\u65d7\u56de\u6d41", 13),
    CUSTOM_ACCOUNT("\u6d3b\u52a8\u81ea\u5b9a\u4e49\u8d26\u6237", 14),
    KUWO_ACCOUNT("\u9177\u6211\u8d26\u6237", 15),
    GUESS_REDPACKET("\u731c\u7ea2\u5305", 16),
    SIGN_PET_UNCOLLECT_MILK("\u7b7e\u5230\u517b\u6210\u672a\u6536\u96c6\u725b\u5976", 17),
    SIGN_PET_COLLECT_MILK("\u7b7e\u5230\u517b\u6210\u5976\u74f6\u5976\u91cf", 18),
    SHENYANG_CMB("\u6c88\u9633\u62db\u884c\u62c6\u7ea2\u5305\u8d26\u6237", 19);

    private static final ImmutableSet<AccountTypeEnum> ACCESS_DRAWS;
    private static final ImmutableSet<AccountTypeEnum> EXPIRE_DRAWS;
    private static final ImmutableMap<Integer, AccountTypeEnum> ALL_MAP;
    private String desc;
    private Integer code;

    public static boolean isAccessDraws(AccountTypeEnum input) {
        return ACCESS_DRAWS.contains((Object)input);
    }

    public static boolean isExpireDraws(AccountTypeEnum input) {
        return EXPIRE_DRAWS.contains((Object)input);
    }

    public static AccountTypeEnum find(Integer code) {
        return (AccountTypeEnum)((Object)ALL_MAP.get((Object)code));
    }

    private AccountTypeEnum(String desc, Integer code) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getCode() {
        return this.code;
    }

    static {
        ACCESS_DRAWS = ImmutableSet.of((Object)((Object)GLOBAL_REWARD), (Object)((Object)HAND_REWARD), (Object)((Object)FZ_GUESS), (Object)((Object)ALL_WALLET), (Object)((Object)AQY_WALLET), (Object)((Object)MASTER_DISCIPLE_SYSTEM), (Object[])new AccountTypeEnum[]{LOTTERY_SQUARE, CUSTOM_ACCOUNT, SHUQI_REFLUX, KUWO_ACCOUNT, GUESS_REDPACKET});
        EXPIRE_DRAWS = ImmutableSet.of((Object)((Object)ALL_WALLET));
        HashMap temp = Maps.newHashMap();
        for (AccountTypeEnum type : AccountTypeEnum.values()) {
            temp.put(type.getCode(), type);
        }
        ALL_MAP = ImmutableMap.copyOf((Map)temp);
    }
}

