package cn.com.duiba.projectx.sdk.repeatable;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: EventContextWapper.java , v 0.1 2020-01-31 6:17 下午 ZhouFeng Exp $
 */
public class EventContextWrapper {

    private Object value;


    /**
     * 前端是否可见
     */
    private boolean visible = false;

    private EventContextWrapper() {
    }

    /**
     * 创建一个参数包装对象，该对象在返回给前端时，前端不可见
     *
     * @param value
     * @return
     */
    public static EventContextWrapper of(Object value) {
        EventContextWrapper wrapper = new EventContextWrapper();
        wrapper.value = value;

        return wrapper;
    }

    /**
     * 创建一个参数包装对象
     *
     * @param value
     * @param visible 该参数为true时，表示该值前端可见，否则前端不可见
     * @return
     */
    public static EventContextWrapper of(Object value, boolean visible) {
        EventContextWrapper wrapper = new EventContextWrapper();
        wrapper.value = value;
        wrapper.visible = visible;
        return wrapper;
    }

    public Object getValue() {
        return value;
    }

    public boolean isVisible() {
        return visible;
    }
}
