package cn.com.duiba.projectx.sdk;

import cn.com.duiba.projectx.sdk.data.IpAreaData;

import javax.servlet.http.HttpServletRequest;

/**
 * 用户请求参数
 *
 * @author houwen
 */
public interface UserRequestContext extends ProjectContext {

    /**
     * HttpServletRequest
     *
     * @return
     */
    HttpServletRequest getHttpRequest();

    String getUserId();

    /**
     * 获取兑吧用户的DuibaPartnerUserId
     * @return
     */
    String getPartnerUserId();

    /**
     * 从请求域中获取绑定好数据的对象
     *
     * @param clazz
     * @param <T>
     * @return
     */
    <T> T bindingDataWithCheck(Class<T> clazz);

    /**
     * 获取用户的请求ip及所在地
     *
     * @return
     */
    IpAreaData getIpData();

    /**
     * 获取 HttpServletRequest 参数
     * <p>
     *    等同于 context.getHttpRequest().getParameter("name")
     * </p>
     * @param name
     * @return
     */
    String getStringParameter(String name);

    /**
     * 获取 HttpServletRequest 参数
     * <p>
     *  等同于 context.getHttpRequest().getParameter("name")
     * </p>
     * @param name
     * @return
     */
    String getStringParameter(String name, String def);

    /**
     * 获取 HttpServletRequest 参数
     * <p>
     *  1. 获取参数值, 为空或者空字符串, 抛出异常
     *  2. 返回参数值
     * </p>
     *
     * @param name
     * @return
     */
    String checkAndGetStringParameter(String name);

    /**
     * 获取 HttpServletRequest 参数
     * <p>
     *  等同于 Integer.parseInt(context.getHttpRequest().getParameter("name"))
     * </p>
     * @param name
     * @return
     */
    Integer getIntegerParameter(String name);

    /**
     * 获取 HttpServletRequest 参数
     * <p>
     *  等同于 Integer.parseInt(context.getHttpRequest().getParameter("name"))
     * </p>
     * @param name
     * @return
     */
    Integer getIntegerParameter(String name, Integer def);

    /**
     * 获取 HttpServletRequest 参数
     * <p>
     *  1. 获取参数值, 为空或者空字符串, 抛出异常
     *  2. 转为 int 返回
     * </p>
     * @param name
     * @return
     */
    int checkAndGetIntegerParameter(String name);

    /**
     * 获取 HttpServletRequest 参数
     * <p>
     *  等同于 Long.parseLong(context.getHttpRequest().getParameter("name"))
     * </p>
     * @param name
     * @return
     */
    Long getLongParameter(String name);

    /**
     * 获取 HttpServletRequest 参数
     * <p>
     *  等同于 Long.parseLong(context.getHttpRequest().getParameter("name"))
     * </p>
     * @param name
     * @return
     */
    Long getLongParameter(String name, Long def);

    /**
     * 获取 HttpServletRequest 参数
     * <p>
     *  1. 获取参数值, 为空或者空字符串, 抛出异常
     *  2. 转为 long 返回
     * </p>
     * @param name
     * @return
     */
    long checkAndGetLongParameter(String name);
}
