/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.UserRequestContext;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ActivityUtils {
    public static final String PHONE_REG = "^1\\d{10}$";

    public static boolean isPhoneNum(String phoneNum) {
        return Pattern.matches(PHONE_REG, phoneNum);
    }

    public static String generateAutoLoginUrl(UserRequestContext context, UserRequestApi api, String uid) {
        return ActivityUtils.generateAutoLoginUrl(context, api, uid, "0", "", new HashMap<String, String>());
    }

    public static String generateAutoLoginUrl(UserRequestContext context, UserRequestApi api, String uid, String credits, String dcustom, Map<String, String> appendParams) {
        String projectId = (String)context.getValue("projectId");
        String host = context.getHttpRequest().getServerName();
        String scheme = context.getHttpRequest().getScheme();
        String redirectUrl = context.getHttpRequest().getParameter("dbredirect");
        if (StringUtils.isBlank((CharSequence)redirectUrl)) {
            redirectUrl = String.format("%s://%s/projectx/%s/index.html", scheme, host, projectId);
        }
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("uid", uid);
        params.put("credits", credits);
        params.put("dcustom", dcustom);
        params.put("redirect", ActivityUtils.assembleUrl(redirectUrl, appendParams));
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        Map<String, String> signMap = api.getDuibaApi().getSignApi().doSign((long)api.getIntVariable("app_id"), params);
        String url = String.format("%s://%s/autoLogin/autologin", scheme, host);
        return ActivityUtils.assembleUrl(url, signMap);
    }

    private static String assembleUrl(String urlPar, Map<String, String> params) {
        StringBuilder str = new StringBuilder(urlPar);
        if (str.toString().contains("?")) {
            str.append("&");
        } else {
            str.append("?");
        }
        try {
            String timestamp = params.get("timestamp");
            if (timestamp == null || timestamp.length() == 0) {
                str.append("timestamp").append("=").append(timestamp).append("&");
            } else {
                str.append("timestamp").append("=").append(URLEncoder.encode(timestamp, "utf-8")).append("&");
            }
            params.remove("timestamp");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                if (entry.getValue() == null || entry.getValue().length() == 0) {
                    str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
                    continue;
                }
                str.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "utf-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return str.toString();
    }

    public static String dealPhoneNum(String phone) {
        if (ActivityUtils.isPhoneNum(phone)) {
            return phone.substring(0, 3) + "****" + phone.substring(8);
        }
        return phone;
    }

    public static JSONObject getThanksStrategy() {
        JSONObject obj = new JSONObject();
        obj.put("prizeId", (Object)"thanks");
        obj.put("optionId", (Object)"thanks");
        obj.put("prizeType", (Object)0);
        obj.put("name", (Object)"\u8c22\u8c22\u53c2\u4e0e");
        return obj;
    }
}

