/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.utils;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class ExpireTime {
    private final Date expire;

    public static ExpireTime of(long timestamp) {
        return new ExpireTime(new Date(timestamp));
    }

    public static ExpireTime of(Date date) {
        return new ExpireTime(date);
    }

    public static ExpireTime of(LocalDateTime dateTime) {
        return new ExpireTime(Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant()));
    }

    public static ExpireTime duration(long timeout, TimeUnit unit) {
        return new ExpireTime(new Date(unit.toMillis(timeout) + System.currentTimeMillis()));
    }

    private ExpireTime(Date expire) {
        this.expire = expire;
    }

    public long getTimestamp() {
        return this.expire.getTime();
    }

    public Date getDate() {
        return this.expire;
    }

    public LocalDateTime getDateTime() {
        return this.expire.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}

