package cn.com.duiba.projectx.sdk.playway.pet;

import cn.com.duiba.projectx.sdk.UserRequestApi;

import java.util.List;
import java.util.Optional;

/**
 * 养成API
 * @author zhangruofan
 * @date 2020/08/17
 */
public interface PetUserRequestApi extends UserRequestApi {

    /**
     * 消耗积分领养一只宠物
     * 不传ticketNum免费领取
     * 同一类宠物一个用户只能领养一个
     * @param petTypeId pet type id
     * @param petName 给领养宠物取得名字
     * @param ticketNum ticket num
     * @return pet id
     */
    Long adoptPet(Integer petTypeId, String petName, String ticketNum);

    /**
     * 获取宠物信息
     * petId和petTypeId二选一
     * 优先使用petId
     * @param petId pet id
     * @param petTypeId pet type id
     * @return pet info
     */
    Optional<PetInfo> getPetInfo(Long petId, Integer petTypeId);

    /**
     * 获取当前项目宠物配置信息
     * @return pet properties list
     */
    List<PetProperties> getPetProperties();
    /**
     * 触发某个状态
     * 前端触发前需要先获取宠物的当前状态
     * 惰性状态变更，需要保证宠物的状态是最新的
     * 注意该方法内部使用了分布式锁，不能被包在事务中!!!
     * @param petId pet id
     * @param prStatusRecordId petInfo 获取
     * @param statusId status id
     * @param ticketNum 扣积分票据
     * @return active result
     */
    ActiveResult active(Long petId, Long prStatusRecordId, Integer statusId, String ticketNum);

    /**
     * 收割待收割的产出
     * 注意该方法内部使用了分布式锁，不能被包在事务中!!!
     * @param outputRecordId record id
     * @return 是否收割成功
     */
    OutputResult claim(Long outputRecordId);

    /**
     * 给宠物增加经验值
     * 只能给自己的宠物增加经验值
     * @param petId petId
     * @param quantity 数量
     * @param desc 描述
     * @return 是否增加成功
     */
    Boolean addExp(Long petId, Integer quantity, String desc);
}
