package cn.com.duiba.projectx.sdk.redacc;

import javax.validation.constraints.NotNull;

/**
 * 用户账户充值请求类
 */
public class AccRechargeRequest {

    private static final long serialVersionUID = -5624792497219133928L;
    /**
     * 应用id
     */
    @NotNull
    private Long appId;
    /**
     * 兑吧用户id
     */
    @NotNull
    private Long consumerId;
    /**
     * 开发者用户id
     */
    @NotNull
    private String partnerUserId;
    /**
     * 业务类型id  ,needLog==false时可不填
     */
    private AccountBizTypeEnum bizType;
    /**
     * 业务订单号  ,needLog==false时可不填
     */
    private String bizId;
    /**
     * 业务描述  ,needLog==false时可不填
     */
    private String bizDescription;
    /**
     * 备注 非必传
     */
    private String memo;
    /**
     * 金额 大于0 金额单位:分，其他为单个：个
     */
    @NotNull
    private Long changeMoney;
    /**
     * 业务类型相关ID，若无请传null
     */
    private Long relId;
    /**
     * 客户端ip 非必传
     */
    private String clientIp;
    /**
     * 客户端设备信息 非必传
     */
    private String clientUa;
    /**
     * 是否需要记录流水
     */
    @NotNull
    private Boolean needLog;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public AccountBizTypeEnum getBizType() {
        return bizType;
    }

    public void setBizType(AccountBizTypeEnum bizType) {
        this.bizType = bizType;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getBizDescription() {
        return bizDescription;
    }

    public void setBizDescription(String bizDescription) {
        this.bizDescription = bizDescription;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getChangeMoney() {
        return changeMoney;
    }

    public void setChangeMoney(Long changeMoney) {
        this.changeMoney = changeMoney;
    }

    public Long getRelId() {
        return relId;
    }

    public void setRelId(Long relId) {
        this.relId = relId;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getClientUa() {
        return clientUa;
    }

    public void setClientUa(String clientUa) {
        this.clientUa = clientUa;
    }

    public Boolean getNeedLog() {
        return needLog;
    }

    public void setNeedLog(Boolean needLog) {
        this.needLog = needLog;
    }
}
