/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.InnerBizCode;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.repeatable.Component;
import cn.com.duiba.projectx.sdk.repeatable.EventContext;
import cn.com.duiba.projectx.sdk.repeatable.Response;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionNode<I extends UserRequestApi> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected Component<I> component;
    protected Method action;

    public ActionNode(Component<I> component, String action) {
        this(component, component.getAction(action));
    }

    protected ActionNode(Component<I> component, Method action) {
        this.component = component;
        this.action = action;
    }

    public Response<I> doAction(EventContext eventContext, UserRequestContext userRequestContext, I api) {
        try {
            return (Response)this.action.invoke(this.component, eventContext, userRequestContext, api);
        }
        catch (Throwable t) {
            this.LOGGER.info("\u6267\u884c\u5931\u8d25", t);
            this.LOGGER.info("\u65b9\u6cd5\u5185\u90e8\u6267\u884c\u5931\u8d25:{}.{}", new Object[]{this.component.getClass(), this.action.getName(), t.getCause()});
            return Response.errorInterrupt(InnerBizCode.SYSTEM_ERROR);
        }
    }

    public String actionName() {
        return this.action.getName();
    }

    public Component<I> getComponent() {
        return this.component;
    }
}

