package cn.com.duiba.projectx.sdk.pay.union.ums;

import cn.com.duiba.projectx.sdk.pay.union.UnionPayStatus;

import java.util.Map;

/**
 * @author zhangdaqing
 * @Description
 * @date 2023/7/21 09:49
 */
public interface UnionPayUmsApi {
    /**
     * 创建支付订单
     *
     * @param request 请求
     * @return {@link UnionChargeUmsResponse}
     */
    UnionChargeUmsResponse createCharge(UnionChargeUmsRequest request);



    /**
     * 创建退款
     *
     * @param refundRequest 退款请求
     * @return {@link UnionPayUmsRefundResp}
     */
    UnionPayUmsRefundResp createRefund(UnionPayUmsRefundReq refundRequest);


    /**
     * 通知:退款和支付通知 都使用这个
     *
     * @param map 地图
     * @return {@link UnionPayUmsNotifyResp}
     */
    UnionPayUmsNotifyResp notify(Map<String, String> map);


    /**
     * 下单查询
     *
     * @return {@link UnionPayUmsOrderQueryResponse}
     */
    UnionPayUmsOrderQueryResponse orderQuery(Long payRecord);


    /**
     * 查询支付状态
     *
     * @param payRecordId 支付记录id
     * @return {@link UnionPayUmsStatus}
     */
    UnionPayUmsStatus queryPayStatus(Long payRecordId);


}
